/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.event.BcEvent;
import ext.base.event.BcEventHandler;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcWords;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.fx.tree.FxTreeFolder;
import ext.lib.fx.tree.FxTreeItem;
import ext.lib.fx.tree.FxTreeItemHelperImpl;
import ext.lib.fx.tree.FxTreeUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.fx.XdtsProfileTreeView;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.model.XdtsProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

abstract class XdtsProfileTreeItemHelper
extends FxTreeItemHelperImpl
implements BcEventHandler<BcEvent> {
    XdtsProfile profile;
    SqlContext sqlContext;
    DtsWordManager wordManager;
    XdtsProfileTreeView profileTreeView;
    protected List<String> clipboardValueList;

    XdtsProfileTreeItemHelper() {
    }

    public void setProfile(XdtsProfile profile, SqlContext sqlContext, DtsWordManager wordManager, XdtsProfileTreeView profileTreeView) throws Exception {
        this.profile = profile;
        this.sqlContext = sqlContext;
        this.wordManager = wordManager;
        this.profileTreeView = profileTreeView;
    }

    protected void delete(Event ev, FxTreeItem treeItem) throws Exception {
        List treeItemList = FxTreeUtil.extractParent(this.getTreeView().getSelectionModel().getSelectedItems(), null);
        String msg = null;
        if (treeItemList.size() == 1) {
            FxTreeItem treeItemWk = (FxTreeItem)treeItemList.get(0);
            String valueName = null;
            if (treeItemWk.getValue() instanceof XdtsCustomSql) {
                XdtsCustomSql customSql = (XdtsCustomSql)treeItemWk.getValue();
                valueName = customSql.name;
            } else {
                valueName = BcStringUtil.toString(treeItemWk.getValue());
            }
            msg = String.format("'%s' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", valueName);
        } else {
            msg = String.format("%d\u4ef6\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", treeItemList.size());
        }
        if (FxOptionPane.showConfirmDialog((Node)this.getTreeView(), (Object)msg, BcWords.getInstance().confirmation, 3) == 0) {
            ArrayList<FxTreeItem> descendantList1 = new ArrayList<FxTreeItem>();
            int i = 0;
            while (i < treeItemList.size()) {
                FxTreeItem treeItemWk1 = (FxTreeItem)treeItemList.get(i);
                List descendantList2 = FxTreeUtil.createDescendantList(treeItemWk1, true);
                for (FxTreeItem fxTreeItem : descendantList2) {
                    if (descendantList1.contains((Object)fxTreeItem)) continue;
                    descendantList1.add(fxTreeItem);
                }
                ++i;
            }
            this.delete(descendantList1);
        }
    }

    protected void delete(List<FxTreeItem> descendantList) throws Exception {
    }

    protected void copy(Event ev, FxTreeItem treeItem) throws Exception {
        List treeItemList = FxTreeUtil.extractParent(this.getTreeView().getSelectionModel().getSelectedItems(), this.getSubTreeItem());
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.getClass().getName());
        int i = 0;
        while (i < treeItemList.size()) {
            FxTreeItem treeItemWk = (FxTreeItem)treeItemList.get(i);
            paramList.add(Integer.toString(((Object)((Object)treeItemWk)).hashCode()));
            ++i;
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(BcCsvUtil.toCsv(paramList));
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    protected boolean past(Event ev, FxTreeItem treeItem) throws Exception {
        if (BcCollectionUtil.isEmpty(this.clipboardValueList)) {
            return false;
        }
        ArrayList<String> hashCodeList = new ArrayList<String>();
        hashCodeList.addAll(this.clipboardValueList);
        hashCodeList.remove(0);
        ArrayList entityIdList = new ArrayList();
        int i = 0;
        while (i < hashCodeList.size()) {
            int hashCode = BcNumberUtil.parseInteger((String)hashCodeList.get(i));
            List treeItemList = FxTreeUtil.getTreeItemListByHashCode(this.getSubTreeItem(), hashCode);
            this.getLogger().debug("treeItemList=" + treeItemList);
            int j = 0;
            while (j < treeItemList.size()) {
                FxTreeItem treeItemWk = (FxTreeItem)treeItemList.get(j);
                FxTreeItem treeItemClone = FxTreeUtil.cloneSimple(treeItemWk, null);
                this.temp1(treeItemClone, treeItem);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected void temp1(TreeItem fromTreeItem, TreeItem toItem) throws Exception {
        ArrayList<String> folderNameList = new ArrayList<String>();
        for (TreeItem treeItemWk = toItem; treeItemWk != this.getSubTreeItem(); treeItemWk = treeItemWk.getParent()) {
            folderNameList.add(BcStringUtil.toString(treeItemWk.getValue()));
        }
        Collections.reverse(folderNameList);
        String group = BcStringUtil.marge(folderNameList, "/").toString();
        if (fromTreeItem.getValue() instanceof FxTreeFolder) {
            FxTreeItem newTreeItem = this.creaeTreeItem();
            newTreeItem.setValue(fromTreeItem.getValue());
            newTreeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_closed_64x64.png"));
            toItem.getChildren().add((Object)newTreeItem);
            int i = 0;
            while (i < fromTreeItem.getChildren().size()) {
                FxTreeItem child = (FxTreeItem)((Object)fromTreeItem.getChildren().get(i));
                this.temp1(child, newTreeItem);
                ++i;
            }
        }
        this.temp2(fromTreeItem, toItem, group);
    }

    protected void temp2(TreeItem fromTreeItem, TreeItem toItem, String group) throws Exception {
    }
}

