/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxEffectUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsDatasourcePane;
import ext.module.xdts.fx.XdtsProfileListPane_OLD;
import ext.module.xdts.fx.XdtsProfilePane;
import ext.module.xdts.fx.XdtsProfileWizard;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.stub.XdtsProfileStub;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class XdtsProfileRowPane
extends FxBorderPane {
    public static final int STYLE_1 = 1;
    public static final int STYLE_2 = 2;
    XdtsDatasourcePane datasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.displaySimple);
    Pane controlPane;
    Button connectButton = new Button();
    Button editButton = new Button();
    Button deleteButton = new Button();
    Color colorBase = FxCssUtil.setOpacity(Color.web((String)"0x888888"), 0.4);
    Color colorHover = FxCssUtil.setOpacity(Color.AQUA, 0.4);
    XdtsProfile profile;
    XdtsProfileListPane_OLD profileListPane;

    public XdtsProfileRowPane(XdtsProfileListPane_OLD profileListPane, int styleId) throws Exception {
        this.profileListPane = profileListPane;
        double width = 0.0;
        double height = 0.0;
        boolean isButtonText = false;
        if (styleId == 2) {
            HBox hBox = new HBox(3.0);
            hBox.setAlignment(Pos.CENTER);
            hBox.setPrefSize(0.0, 32.0);
            this.setBottom((Node)this.controlPane);
            this.controlPane = hBox;
            width = this.datasourcePane.getPrefWidth();
            height = this.datasourcePane.getPrefHeight();
            isButtonText = true;
        } else {
            VBox vBox = new VBox(3.0);
            vBox.setAlignment(Pos.TOP_CENTER);
            vBox.setPadding(new Insets(4.0, 4.0, 4.0, 4.0));
            vBox.setSpacing(2.0);
            vBox.setPrefSize(32.0, 0.0);
            this.setRight((Node)vBox);
            this.controlPane = vBox;
            width = this.datasourcePane.getPrefWidth() + 32.0;
            height = this.datasourcePane.getPrefHeight() + 4.0;
        }
        FxUtil.setEditable((Node)this.datasourcePane, false);
        this.setCenter((Node)this.datasourcePane);
        this.connectButton.setOnAction(this.actionEventHandler);
        this.connectButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_connection_64x64.png"));
        if (isButtonText) {
            this.connectButton.setText(BcWords.getInstance().connect);
        }
        this.connectButton.setTooltip(new Tooltip(BcWords.getInstance().connection));
        this.controlPane.getChildren().add((Object)this.connectButton);
        this.editButton.setOnAction(this.actionEventHandler);
        this.editButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
        if (isButtonText) {
            this.editButton.setText(BcWords.getInstance().edit);
        }
        this.editButton.setTooltip(new Tooltip(XdtsWords.getInstance().editDataSourcePProfile));
        this.controlPane.getChildren().add((Object)this.editButton);
        this.deleteButton.setOnAction(this.actionEventHandler);
        this.deleteButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        if (isButtonText) {
            this.deleteButton.setText(BcWords.getInstance().delete);
        }
        this.deleteButton.setTooltip(new Tooltip(XdtsWords.getInstance().deleteProfile));
        this.controlPane.getChildren().add((Object)this.deleteButton);
        this.setPrefSize(width, height);
        this.setStyle(FxCssUtil.css_backgroundColor_linearGradient("#1B314B", "#465B77", 6));
        this.setEffect((Effect)FxEffectUtil.createDropShadow());
        this.setColore(this.colorBase);
    }

    public void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
        this.datasourcePane.setData(profile);
    }

    @Override
    public void mouseEvent(MouseEvent ev) throws Exception {
        if (ev.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.setColore(this.colorHover);
        } else if (ev.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.setColore(this.colorBase);
        } else if (ev.getEventType() != MouseEvent.MOUSE_PRESSED) {
            ev.getEventType();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        XdtsProfile profile2;
        String msg;
        super.actionPerformed(ev);
        if (ev.getSource() == this.connectButton) {
            XdtsProfilePane.show2(this.profile.getDataId(), this.getScene().getWindow());
        } else if (ev.getSource() == this.editButton) {
            XdtsProfile profile22 = XdtsProfileStub.getInstance().getProfile(this.profile.getDataId());
            XdtsProfileWizard profileWizard = new XdtsProfileWizard();
            if ((profile22 = XdtsProfileWizard.show2(profile22, this.getScene().getWindow())) != null) {
                this.setProfile(profile22);
            }
        } else if (ev.getSource() == this.deleteButton && FxOptionPane.showConfirmDialog((Node)this, (Object)(msg = String.valueOf(SqlWords.getInstance().dataSource) + "'" + this.profile.name + "' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f"), BcWords.getInstance().confirmation, 3) == 0 && (profile2 = XdtsProfileStub.getInstance().deleteProfile(this.profile.getDataId())) != null) {
            this.profileListPane.doLoad();
        }
    }

    public void setColore(Color color) throws Exception {
        this.datasourcePane.centerPane.setStyle(FxCssUtil.css_BG_FG(color, null));
        this.controlPane.setStyle(FxCssUtil.css_BG_FG(color, null).toString());
    }
}

