/*
 * Decompiled with CFR 0.152.
 */
package ext.module.tmnl.dao;

import ext.base.core.BcInteger;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.orm.persistence.OrmPersistenceUtil;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.module.tmnl.dao.TmnlTerminalPropertyDAO;
import ext.module.tmnl.model.TmnlTerminal;
import ext.scf.common.ScfConstants;
import ext.scf8.cluster.controller.KscfMulticastData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmnlTerminalDAO
extends OrmAbstractDAO {
    private Map<Integer, TmnlTerminal> dataIdMap = new HashMap<Integer, TmnlTerminal>();

    private TmnlTerminalDAO() {
        super(new Object[0]);
    }

    public static TmnlTerminalDAO getInstance() {
        return SingletonHolder.instance;
    }

    public void multicastPacketReceived(KscfMulticastData multicastData, Object dataObject) throws Exception {
        Object[] dataArray = (Object[])dataObject;
        String methodName = dataArray[0].toString();
        BcLogUtil.debug("multicastPacketReceived.methodName=" + methodName);
        if (!BcStringUtil.equals(methodName, "removeTerminalCash")) {
            throw new Exception("multicastPacketReceived.methodName=" + methodName);
        }
        int terminalId = (Integer)dataArray[1];
        this.removeTerminalCash(terminalId, false);
    }

    public void removeTerminalCash(int terminalId, boolean doNitify) throws Exception {
        this.dataIdMap.remove(terminalId);
    }

    public int putTerminal(DtsSession dtsSession, TmnlTerminal terminal) throws Exception {
        this.removeTerminalCash(terminal.getDataId(), true);
        return this.putTerminal2(dtsSession, terminal);
    }

    public int putTerminal2(DtsSession dtsSession, TmnlTerminal terminal) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String tableName = "tmnl_terminal";
        OrmPersistenceUtil.putPreTrans(dtsSession, terminal, tableName);
        String query = " UPDATE " + tableName + " SET" + this.getPersistenceProxy().createCommonSetPhrase(sqlContext, (Object)terminal) + ",native_id=" + sqlContext.toSet(terminal.nativeId) + ",terminal_type_id=" + sqlContext.toSet(terminal.terminalTypeId) + ",code=" + sqlContext.toSet(terminal.code) + ",name=" + sqlContext.toSet(terminal.name) + ",ip_address=" + sqlContext.toSet(terminal.ipAddress) + ",person_id=" + sqlContext.toSet(terminal.personId) + this.getPersistenceProxy().createWhereClause(terminal);
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            stmt.executeUpdate(query);
        }
        return terminal.getDataId();
    }

    public int deleteTerminal(DtsSession dtsSession, int terminalId) throws Exception {
        int resValue = this.getPersistenceProxy().logicalDeleteByDataId(dtsSession, "tmnl_terminal", terminalId);
        TmnlTerminalPropertyDAO.getInstance().deleteProperties(dtsSession, terminalId);
        this.removeTerminalCash(terminalId, true);
        return resValue;
    }

    public int deleteTerminalByDomainId(DtsSession dtsSession, int domainId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int cnt = 0;
        String query = " SELECT id FROM tmnl_terminal WHERE sy_domain_id=" + domainId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                int terminalId = rs.getInt(1);
                ++cnt;
                int cnt2 = this.getPersistenceProxy().physicalDeleteByDataId(dtsSession, "tmnl_terminal", terminalId);
                TmnlTerminalPropertyDAO.getInstance().deleteProperties(dtsSession, terminalId);
            }
            rs.close();
        }
        return cnt;
    }

    public boolean getTerminalByObjectId(DtsSession dtsSession, int objectId, TmnlTerminal terminal) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        boolean resValue = false;
        String query = " SELECT" + this.getPersistenceProxy().createCommonSelectPhrase(TmnlTerminal.class) + ",native_id" + ",terminal_type_id" + ",code" + ",name" + ",ip_address" + ",person_id" + " FROM" + " tmnl_terminal" + this.getPersistenceProxy().createObjectIdWhereClause(objectId);
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, terminal);
                terminal.nativeId = rs.getString(columnIndex);
                terminal.terminalTypeId = rs.getInt(columnIndex);
                terminal.code = rs.getString(columnIndex);
                terminal.name = rs.getString(columnIndex);
                terminal.ipAddress = rs.getString(columnIndex);
                terminal.personId = rs.getInt(columnIndex);
                resValue = true;
            }
            rs.close();
        }
        return resValue;
    }

    public boolean getTerminal(DtsSession dtsSession, int terminalId, TmnlTerminal terminal) throws Exception {
        int objectId = this.getPersistenceProxy().getObjectIdNewest(dtsSession, "tmnl_terminal", terminalId);
        return this.getTerminalByObjectId(dtsSession, objectId, terminal);
    }

    public TmnlTerminal getTerminal(DtsSession dtsSession, int terminalId) throws Exception {
        TmnlTerminal terminal = this.dataIdMap.get(terminalId);
        if (terminal == null) {
            terminal = this.getTerminal2(dtsSession, terminalId);
            if (terminal == null) {
                return null;
            }
            this.dataIdMap.put(terminal.getDataId(), terminal);
            return terminal;
        }
        return terminal;
    }

    public TmnlTerminal getTerminal2(DtsSession dtsSession, int terminalId) throws Exception {
        TmnlTerminal terminal = new TmnlTerminal();
        if (this.getTerminal(dtsSession, terminalId, terminal)) {
            return terminal;
        }
        return null;
    }

    public int getTerminalIdByCode(DtsSession dtsSession, int domainId, String terminalCode) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = -1;
        String query = " SELECT id FROM " + ScfConstants.toValidViewName_OLD("tmnl_terminal") + " WHERE" + " code" + sqlContext.toCondition_string("=", terminalCode);
        if (domainId > 0) {
            query = String.valueOf(query) + " AND" + " " + "sy_domain_id" + "=" + domainId;
        }
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getInt(1);
            }
            rs.close();
        }
        return resValue;
    }

    public TmnlTerminal getTerminalByCode(DtsSession dtsSession, int domainId, String terminalCode) throws Exception {
        int terminald = this.getTerminalIdByCode(dtsSession, domainId, terminalCode);
        return this.getTerminal(dtsSession, terminald);
    }

    public int getTerminalIdByName(DtsSession dtsSession, int domainId, String terminalName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = -1;
        String query = " SELECT id FROM " + ScfConstants.toValidViewName_OLD("tmnl_terminal") + " WHERE" + " name" + sqlContext.toCondition_string("=", terminalName);
        if (domainId > 0) {
            query = String.valueOf(query) + " AND" + " " + "sy_domain_id" + "=" + domainId;
        }
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getInt(1);
            }
            rs.close();
        }
        return resValue;
    }

    public int getTerminalIdByNativeId(DtsSession dtsSession, int domainId, String nativeId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = -1;
        String query = " SELECT id FROM " + ScfConstants.toValidViewName_OLD("tmnl_terminal") + " WHERE" + " native_id" + sqlContext.toCondition_string("=", nativeId);
        if (domainId > 0) {
            query = String.valueOf(query) + " AND" + " " + "sy_domain_id" + "=" + domainId;
        }
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getInt(1);
            }
            rs.close();
        }
        return resValue;
    }

    public int getTerminalIdByIpAddress(DtsSession dtsSession, int domainId, String ipAddress) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = -1;
        String query = " SELECT id FROM " + ScfConstants.toValidViewName_OLD("tmnl_terminal") + " WHERE" + " ip_address" + sqlContext.toCondition_string("=", ipAddress);
        if (domainId > 0) {
            query = String.valueOf(query) + " AND" + " " + "sy_domain_id" + "=" + domainId;
        }
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resValue = rs.getInt(1);
            }
            rs.close();
        }
        return resValue;
    }

    public boolean getTerminalList(DtsSession dtsSession, int domainId, List<TmnlTerminal> terminalList) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        boolean resValue = false;
        String query = " SELECT id FROM " + ScfConstants.toValidViewName_OLD("tmnl_terminal");
        if (domainId > 0) {
            query = String.valueOf(query) + " WHERE sy_domain_id=" + domainId;
        }
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                resValue = true;
                terminalList.add(this.getTerminal(dtsSession, rs.getInt(1)));
            }
            rs.close();
        }
        return resValue;
    }

    public List<TmnlTerminal> getTerminalList(DtsSession dtsSession, int domainId) throws Exception {
        ArrayList<TmnlTerminal> terminalList = new ArrayList<TmnlTerminal>();
        this.getTerminalList(dtsSession, domainId, terminalList);
        return terminalList;
    }

    /* synthetic */ TmnlTerminalDAO(TmnlTerminalDAO tmnlTerminalDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final TmnlTerminalDAO instance = new TmnlTerminalDAO(null);

        private SingletonHolder() {
        }
    }
}

