/*
 * Decompiled with CFR 0.152.
 */
package ext.module.mqsv.server;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.util.BcUuidUtil;
import ext.base.xml.BcXmlUtil;
import ext.module.mqsv.common.MqsvConstants;
import ext.module.mqsv.common.MqsvMessage;
import ext.module.mqsv.common.MqsvMessageEventHandler;
import ext.module.mqsv.common.MqsvMessageListenerContext;
import ext.module.mqsv.server.MqsvAcceptThread;
import ext.module.mqsv.server.MqsvRecieveThread;
import ext.module.mqsv.server.MqsvSendThread;
import ext.scf.server.ScfAbstractServerModule;
import ext.scf.server.ScfServerContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MqsvService
extends ScfAbstractServerModule {
    protected Vector<MqsvRecieveThread> reqRecieveThreadList = new Vector();
    protected Vector<MqsvSendThread> msgSendThreadList = new Vector();
    protected Vector<MqsvMessageEventHandler> messagetListenerList = new Vector();
    protected String address;
    protected int port;
    protected int backlogCount = 8;
    protected boolean isValid;
    protected int logLevel;
    protected MqsvAcceptThread acceptThread;
    protected String tempDataDirPath = "${APP}data/message_server/";
    protected String logDirPath = "${APP}log/message_server/";
    protected String logEntryName = "message_server_general";
    protected boolean setupFlag;

    @Override
    public void init() throws Exception {
        Node baseNode = BcXmlUtil.getNode(ScfServerContainer.getInstance().getConfig(), "messageServer");
        if (baseNode == null) {
            return;
        }
        this.address = BcXmlUtil.getTextValue(baseNode, "address");
        this.port = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "port"), -1);
        this.logLevel = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "logLevel"), -1);
        Node domNode2 = BcXmlUtil.getNode(baseNode, "entryMessageListener");
        if (domNode2 != null) {
            this.parseEntryMessageListener(domNode2);
        }
        this.setupFlag = true;
    }

    public boolean parseEntryMessageListener(Node domNode) throws Exception {
        MqsvMessageListenerContext msgListenerContext = new MqsvMessageListenerContext();
        NodeList domNodeList = domNode.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode2 = domNodeList.item(i);
            if (domNode2.getNodeName().equals("address")) {
                msgListenerContext.address = BcXmlUtil.getValue(domNode2, 3, "");
            } else if (domNode2.getNodeName().equals("port")) {
                msgListenerContext.port = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "-1"));
            } else if (domNode2.getNodeName().equals("protocol")) {
                msgListenerContext.protocol = BcXmlUtil.getValue(domNode2, 3, "");
            } else if (domNode2.getNodeName().equals("timeout")) {
                msgListenerContext.soTimeoutMilliSec = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "0"));
            } else if (domNode2.getNodeName().equals("retryWait")) {
                msgListenerContext.retryWaitMilliSec = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "-1"));
            } else if (domNode2.getNodeName().equals("retryMax")) {
                msgListenerContext.retryMax = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "-1"));
            } else if (domNode2.getNodeName().equals("dataCashMax")) {
                msgListenerContext.dataCashMax = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "-1"));
            } else if (domNode2.getNodeName().equals("target")) {
                msgListenerContext.addTargetClassName(BcXmlUtil.getValue(domNode2, 3, ""));
            }
            ++i;
        }
        if (BcStringUtil.isEmpty(msgListenerContext.address)) {
            return false;
        }
        if (msgListenerContext.port < 1) {
            return false;
        }
        return msgListenerContext.protocol.equals("socket:xml");
    }

    protected boolean parseRemoveMessageListener(Node domNode) throws Exception {
        boolean resBool = false;
        String address = "";
        int port = -1;
        NodeList domNodeList = domNode.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode2 = domNodeList.item(i);
            if (domNode2.getNodeName().equals("address")) {
                address = BcXmlUtil.getValue(domNode2, 3, "");
            } else if (domNode2.getNodeName().equals("port")) {
                port = BcNumberUtil.parseInteger(BcXmlUtil.getValue(domNode2, 3, "-1"));
            }
            ++i;
        }
        return resBool;
    }

    @Override
    public void start() throws Exception {
        if (!this.setupFlag) {
            return;
        }
        BcLogUtil.info(BcLogUtil.createLabel("Message Server", "*", 4, 40));
        this.startNoticeService();
        if (this.acceptThread == null) {
            this.acceptThread = new MqsvAcceptThread(this);
        }
        this.acceptThread.startAccept();
        BcLogUtil.info(" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNoticeService() throws Exception {
        String logFilePath = String.valueOf(AfbApplication.getInstance().toReal(this.logDirPath)) + "/" + "message_server_log.txt";
        String filePath = AfbApplication.getInstance().getRootDirectry() + "/log/jsb_notice.log";
        BcLogger logger = BcLogUtil.createLogger("jsb_notice", false, BcLogConstants.LogLevel.DEBUG, true, new File(filePath));
        this.isValid = true;
        Vector<MqsvSendThread> vector = this.msgSendThreadList;
        synchronized (vector) {
            int i = 0;
            while (i < this.msgSendThreadList.size()) {
                MqsvSendThread msgSendThread = this.msgSendThreadList.get(i);
                msgSendThread.threadMon.unLock();
                ++i;
            }
        }
    }

    public void addListenerContext(MqsvMessageListenerContext msgListenerContext) throws Exception {
        boolean isNew = true;
        int i = 0;
        while (i < this.msgSendThreadList.size()) {
            MqsvSendThread msgSendThread = this.msgSendThreadList.get(i);
            if (msgSendThread.msgListenerContext.address.equals(msgListenerContext.address) && msgSendThread.msgListenerContext.port == msgListenerContext.port) {
                msgSendThread.setMessageListenerContext(msgListenerContext);
                isNew = false;
                break;
            }
            ++i;
        }
        if (isNew) {
            msgListenerContext.failedLogEntryName = String.valueOf(msgListenerContext.address) + "_" + msgListenerContext.port + "_error.txt";
            String logFilePath = String.valueOf(AfbApplication.getInstance().toReal(this.logDirPath)) + "/" + msgListenerContext.failedLogEntryName;
            BcLogger logger = BcLogUtil.createLogger("jsb_notice", false, BcLogConstants.LogLevel.DEBUG, true, new File(logFilePath));
            MqsvSendThread msgSendThread = new MqsvSendThread(this);
            msgSendThread.setMessageListenerContext(msgListenerContext);
            this.msgSendThreadList.add(msgSendThread);
            if (this.isValid) {
                msgSendThread.threadMon.unLock();
            }
            BcLogUtil.info("\u30e1\u30c3\u30bb\u30fc\u30b8\u30ea\u30b9\u30ca\u3092\u30a8\u30f3\u30c8\u30ea\u3057\u307e\u3057\u305f\u3002");
            BcLogUtil.info("     address=" + msgListenerContext.address);
            BcLogUtil.info("        port=" + msgListenerContext.port);
            BcLogUtil.info("    protocol=" + msgListenerContext.protocol);
            BcLogUtil.info("     timeout=" + msgListenerContext.soTimeoutMilliSec);
            BcLogUtil.info("   retryWait=" + msgListenerContext.retryWaitMilliSec);
            BcLogUtil.info("    retryMax=" + msgListenerContext.retryMax);
            BcLogUtil.info(" dataCashMax=" + msgListenerContext.dataCashMax);
        }
    }

    public void removeListenerContext(String address, int port) {
        int i = 0;
        while (i < this.msgSendThreadList.size()) {
            MqsvSendThread msgSendThread = this.msgSendThreadList.get(i);
            if (msgSendThread.msgListenerContext.address.equals(address) && msgSendThread.msgListenerContext.port == port) {
                this.removeMessageSendThread(msgSendThread);
            }
            ++i;
        }
    }

    public void removeMessageSendThread(MqsvSendThread msgSendThread) {
        this.msgSendThreadList.remove(msgSendThread);
        msgSendThread.stopThread();
    }

    public void addRequestRecieveThread(MqsvRecieveThread reqRecieveThread) {
        this.reqRecieveThreadList.add(reqRecieveThread);
        reqRecieveThread.threadMon.unLock();
    }

    public void removeRequestRecieveThread(MqsvRecieveThread reqRecieveThread) {
        reqRecieveThread.stopThread();
        this.reqRecieveThreadList.remove(reqRecieveThread);
    }

    public void addMessageListener(MqsvMessageEventHandler listener) {
        this.messagetListenerList.add(listener);
    }

    public void removeMessageListener(MqsvMessageEventHandler listener) {
        this.messagetListenerList.remove(listener);
    }

    public void addMessage(MqsvMessage msg) {
        if (!this.setupFlag) {
            return;
        }
        UUID uuid = BcUuidUtil.createUUID();
        msg.uuid = uuid.toString();
        if (msg.userObject instanceof Document) {
            Document domDoc = (Document)msg.userObject;
            Node rootNode = domDoc.getFirstChild();
            ((Element)rootNode).setAttribute("messageId", msg.uuid);
            Element elemL1 = domDoc.createElement("metaData");
            rootNode.insertBefore(elemL1, rootNode.getFirstChild());
            Calendar calendar = BcTimeUtil.createCalendar();
            Element elemL2 = MqsvConstants.createTimeElement(elemL1, "entryDateTime", calendar, "yyyy/MM/dd HH:mm:ss.SSS");
            elemL1.appendChild(elemL2);
        }
        try {
            String filePath = AfbApplication.getInstance().toReal(String.valueOf(this.logDirPath) + "/data_files/" + msg.uuid + ".xml");
            File file = new File(filePath);
            BcFileUtil.makeParent(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), false);
            this.outputMessage(fileOutputStream, msg, true);
            fileOutputStream.close();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        int i = 0;
        while (i < this.msgSendThreadList.size()) {
            MqsvSendThread msgSendThread = this.msgSendThreadList.get(i);
            msgSendThread.addMessage(msg);
            ++i;
        }
    }

    public void outputMessage(OutputStream os, MqsvMessage msg, boolean isLog) throws Exception {
        Object obj = msg.userObject;
        if (obj instanceof byte[]) {
            os.write((byte[])obj);
            os.flush();
        } else if (obj instanceof Document) {
            Document domDoc = (Document)obj;
            BcXmlUtil.output(domDoc, os, isLog);
        }
    }
}

