/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.dao;

import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.context.SqlContext;
import ext.module.impt.model.ImptImportContext;
import java.util.Calendar;

public class ImptImportContextDAO
extends OrmAbstractDAO<ImptImportContext> {
    public ImptImportContextDAO() {
        super(new ImptImportContext[0]);
        this.setTableName("impt_import_context");
    }

    public static ImptImportContextDAO getInstance() {
        return SingletonHolder.instance;
    }

    public void putImportContext(DtsSession dtsSession, ImptImportContext importContext) throws Exception {
        this.getPersistenceProxy().putEntitys_3(dtsSession, this.getTableName(), importContext);
    }

    public int deleteImportContext(DtsSession dtsSession, int importContextId) throws Exception {
        int resValue = this.getPersistenceProxy().physicalDeleteByDataId(dtsSession, this.getTableName(), importContextId);
        return resValue;
    }

    public ImptImportContext getImportContext(DtsSession dtsSession, int importContextId) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + this.getPersistenceProxy().createDataIdWhereClause(importContextId);
        return (ImptImportContext)this.getEntity(dtsSession, query);
    }

    public ImptImportContext getImportContextByLastModified(DtsSession dtsSession, Calendar lastModified) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + " WHERE " + sqlContext.toCondition_timestamp("file_last_modified", lastModified);
        return (ImptImportContext)this.getEntity(dtsSession, query);
    }

    public ImptImportContext getImportContextNewest(DtsSession dtsSession) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + " ORDER BY " + "id" + " DESC";
        return (ImptImportContext)this.getEntity(dtsSession, query);
    }

    public ImptImportContext getImportContextBySourcePreserveUrlAndNote(DtsSession dtsSession, String sourceUrl, String note) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + " WHERE source_url" + sqlContext.toCondition_string("=", sourceUrl) + " AND note_" + sqlContext.toCondition_string("=", note) + " ORDER BY start_time DESC";
        return (ImptImportContext)this.getEntity(dtsSession, query);
    }

    private static final class SingletonHolder {
        private static final ImptImportContextDAO instance = new ImptImportContextDAO();

        private SingletonHolder() {
        }
    }
}

