/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.swg;

import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.module.dcmn.rmo.DcmnDocumentTemplateRMO;
import ext.module.dcmn.stub.DcmnDocumentTemplateStub;
import ext.module.dcmn.swg.DcmnDocumentTemplatePanel;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf5.swg.IswgLoadableTablePanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;

public class DcmnDocumentTemplateListPanel
extends IswgLoadableTablePanel {
    protected SwgButton addButton;
    protected SwgButton openButton;
    protected SwgButton deleteButton;
    protected SwgButton closeButton;
    RmiRequest rmiReq;

    public DcmnDocumentTemplateListPanel() throws Exception {
        this.addButton = new SwgButton(BcWords.getInstance().add);
        this.openButton = new SwgButton(BcWords.getInstance().open, new ImageIcon(AwtImageHelper.getImageAsIcon("folder_opened_64x64.png")));
        this.deleteButton = new SwgButton(BcWords.getInstance().delete, new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png")));
        this.closeButton = new SwgButton(BcWords.getInstance().close);
        this.rmiReq = new RmiRequest();
        this.addButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.addButton);
        this.openButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.openButton);
        this.deleteButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.deleteButton);
        this.closeButton.addActionListener(this.actionListener);
        this.tableControlPanel.addControl3(this.closeButton);
        this.rmiReq.setClassName(DcmnDocumentTemplateRMO.class.getName());
        this.rmiReq.setMethodName("getDocumentTemplateList");
        this.doLoad(this.rmiReq);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        SwgTableView tableView = this.getTableView();
        BcTableColumnModel tableColumnModel = this.getTableModel().getTableColumnModel();
        if (ev.getSource() == this.addButton) {
            DcmnDocumentTemplatePanel documentTemplatePanel = new DcmnDocumentTemplatePanel();
            documentTemplatePanel.showAsDialog(-1, this);
        } else if (ev.getSource() == this.openButton) {
            List dataIdList = SwgTableViewUtil.getSelectedValueList(tableView, tableColumnModel.getIndexByTableColumnName("dcmn_document_template.id"), true);
            if (dataIdList.size() > 0) {
                int defineIndexId = (Integer)dataIdList.get(0);
                DcmnDocumentTemplatePanel defineIndexPanel = new DcmnDocumentTemplatePanel();
                defineIndexPanel.showAsDialog(defineIndexId, this);
            }
        } else if (ev.getSource() == this.deleteButton) {
            List dataIdList = SwgTableViewUtil.getSelectedValueList(tableView, tableColumnModel.getIndexByTableColumnName("dcmn_document_template.id"), true);
            if (dataIdList.size() > 0) {
                int importDefineId = (Integer)dataIdList.get(0);
                if (JOptionPane.showConfirmDialog(this, "\u524a\u9664\u3092\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f", BcWords.getInstance().confirmation, 0) == 0) {
                    DcmnDocumentTemplateStub.getInstance().deleteDocumentTemplate(importDefineId);
                }
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
            Container container = this.getParent();
            container.remove(this);
        }
    }

    @Override
    public void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        this.setPogressIndicator();
        this.tableControlPanel.setControlEnabled3(true);
    }

    @Override
    public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
        super.tableLoadFinished(tableLoadTask, eod);
        this.openButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    @Override
    protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
        super.tableSelectionChanged(ev);
        if (ev.getValueIsAdjusting()) {
            return;
        }
        this.openButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        SwgTableView tableView = this.getTableView();
        int[] rowViewIdxs = tableView.getSelectedRows();
        if (rowViewIdxs.length == 0) {
            return;
        }
        this.openButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    @Override
    protected void tableMouseClicked(MouseEvent ev) throws Exception {
        DcmnDocumentTemplatePanel \uff44efineIndexPanel;
        int idColmnIndex;
        super.tableMouseClicked(ev);
        if (ev.getClickCount() != 2) {
            return;
        }
        SwgTableView tableView = this.getTableView();
        BcTableColumnModel tableColumnModel = this.getTableModel().getTableColumnModel();
        int rowViewIdx = tableView.rowAtPoint(ev.getPoint());
        int defineIndexId = ((Number)tableView.getValueAt(rowViewIdx, idColmnIndex = tableColumnModel.getIndexByTableColumnName("dcmn_document_template.id"))).intValue();
        if (defineIndexId > 0 && (\uff44efineIndexPanel = new DcmnDocumentTemplatePanel()).showAsDialog(defineIndexId, this)) {
            this.doLoad(this.rmiReq);
        }
    }
}

