/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.task;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLoggableObject;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskEvent;
import ext.lib.task.TskTaskMonitor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TskTaskManager
extends BcLoggableObject
implements BcEventHandler<TskTaskEvent> {
    private static Map<String, TskCallableUnit> callableUnitMap = new ConcurrentHashMap<String, TskCallableUnit>();
    private TskTaskMonitor taskMonitor;

    private TskTaskManager() {
    }

    public static TskTaskManager getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, TskCallableUnit> getMap() {
        return callableUnitMap;
    }

    public void addCallableUnit(TskCallableUnit callableUnit) throws Exception {
        callableUnitMap.put(callableUnit.getId(), callableUnit);
        callableUnit.callable.addEventHandler(TskTaskManager.getInstance());
        if (this.taskMonitor != null) {
            this.taskMonitor.addCallableUnit(callableUnit);
        }
        if (callableUnit.future == null) {
            callableUnit.future = callableUnit.executorService.submit(callableUnit.callable);
            callableUnit.executorService.shutdown();
        }
    }

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            TskAbstractCallable callable = (TskAbstractCallable)event.getSource();
            TskCallableUnit callableUnit = callableUnitMap.remove(Integer.toString(callable.hashCode()));
            this.getLogger().debug("Finished:callableUnit.id=" + callableUnit.getId());
        }
    }

    public TskTaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public void setTaskMonitor(TskTaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    /* synthetic */ TskTaskManager(TskTaskManager tskTaskManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final TskTaskManager instance = new TskTaskManager(null);

        private SingletonHolder() {
        }
    }
}

