/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg.calender;

import ext.lib.swg.calender.Holiday;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class JapanHoliday
extends Holiday {
    @Override
    public boolean checkHoliday(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        switch (month) {
            case 0: {
                if (day == 1) {
                    return true;
                }
                if (year < 2000 && day == 15) {
                    return true;
                }
                int mm = this.getSecondMonday(cal);
                if (year < 2000 || cal.get(4) != mm || cal.get(7) != 2) break;
                return true;
            }
            case 1: {
                if (day != 11) break;
                return true;
            }
            case 2: {
                return this.checkVernalEquinoxDay(year, month, day);
            }
            case 3: {
                if (day != 29) break;
                return true;
            }
            case 4: {
                if (day != 3 && day != 4 && day != 5) break;
                return true;
            }
            case 5: {
                break;
            }
            case 6: {
                if (day != 20) break;
                return true;
            }
            case 7: {
                break;
            }
            case 8: {
                if (day == 15) {
                    return true;
                }
                return this.checkAutumnalEquinoxDay(year, month, day);
            }
            case 9: {
                if (year < 2000 && day == 10) {
                    return true;
                }
                int mm = this.getSecondMonday(cal);
                if (year < 2000 || cal.get(4) != mm || cal.get(7) != 2) break;
                return true;
            }
            case 10: {
                if (day != 3 && day != 23) break;
                return true;
            }
            case 11: {
                if (day != 25) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkAnniversary(Calendar cal) {
        return false;
    }

    public int getSecondMonday(Calendar cal) {
        GregorianCalendar tempCal = new GregorianCalendar(cal.get(1), cal.get(2), 1);
        int startDayOfWeek = tempCal.get(7);
        if (startDayOfWeek <= 2) {
            return 2;
        }
        return 3;
    }
}

