/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.json;

import com.fasterxml.jackson.databind.JsonNode;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.json.JacksonUtil;
import java.util.Iterator;

public class JsonNodeVisitor
extends BcLoggableObject {
    public void parse(JsonNode jsonNode, String path, int arrayIndex, String name, String parentName, JsonNode jsonNodeParent) throws Exception {
        if (jsonNode.isObject()) {
            Iterator iter = jsonNode.fieldNames();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                JsonNode jsonNodeChild = jsonNode.get(fieldName);
                this.parse(jsonNodeChild, String.valueOf(path) + "." + fieldName, arrayIndex, fieldName, name, jsonNode);
            }
        } else if (jsonNode.isArray()) {
            Iterator iter = jsonNode.elements();
            int index2 = 0;
            while (iter.hasNext()) {
                JsonNode jsonNodeChild = (JsonNode)iter.next();
                this.parse(jsonNodeChild, String.valueOf(path) + String.format("[%s]", index2), index2, name, parentName, jsonNode);
                ++index2;
            }
        } else {
            this.accept(jsonNode, path, arrayIndex, name, parentName, jsonNodeParent);
        }
    }

    public void parse(JsonNode jsonNode) throws Exception {
        this.parse(jsonNode, JacksonUtil.NodeName.root.name(), -1, JacksonUtil.NodeName.root.name(), null, null);
    }

    protected void accept(JsonNode jsonNode, String path, int arrayIndex, String name, String parentName, JsonNode jsonNodeParent) throws Exception {
        String str = "path=" + path + " arrayIndex=" + arrayIndex + " text=" + jsonNode.asText() + " name=" + name + " parentName=" + parentName + " parentText=" + jsonNodeParent.asText();
        BcLogUtil.debug(str);
    }
}

