/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.itext;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import ext.lib.itext.ItextUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;

public class ItextGraphics2D
extends PdfGraphics2D {
    protected PageFormat pageFormat;

    public ItextGraphics2D(PdfContentByte pdfContentByte, float width, float height, PageFormat pageFormat) throws Exception {
        super(pdfContentByte, width, height);
        this.pageFormat = pageFormat;
    }

    public void setColor(Color awtColor) {
        try {
            BaseColor baseColor = ItextUtil.toBaseColor(awtColor);
            PdfContentByte pdfContentByte = this.getContent();
            pdfContentByte.setColorStroke(baseColor);
            pdfContentByte.setColorFill(baseColor);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setFont(Font awtFont) {
        try {
            BaseFont baseFont = ItextUtil.getBaseFont(awtFont.getName(), true);
            if (baseFont == null) {
                String msg = "Not suported font '" + awtFont.getName() + "'.";
                throw new RuntimeException(msg);
            }
            PdfContentByte pdfContentByte = this.getContent();
            if (pdfContentByte != null) {
                pdfContentByte.setFontAndSize(baseFont, (float)awtFont.getSize());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void drawString(String str, float x, float y) {
        try {
            PdfContentByte pdfContentByte = this.getContent();
            pdfContentByte.saveState();
            pdfContentByte.beginText();
            float ax = ItextUtil.toPdfX(this.pageFormat, x);
            float ay = ItextUtil.toPdfY(this.pageFormat, y);
            pdfContentByte.setTextMatrix(ax, ay);
            pdfContentByte.showText(str);
            pdfContentByte.endText();
            pdfContentByte.restoreState();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }
}

