/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.renderer;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.math.BcMath;
import ext.base.util.BcCloneUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.doc.renderer.DcfParseResult;
import ext.lib.doc.renderer.DcfRenderingRow;
import ext.lib.doc.renderer.DcfRenderingText;
import ext.lib.doc.renderer.DcfShapeRenderer;
import ext.lib.doc.renderer.DcfShapeRenderingUtil;
import ext.lib.doc.util.DcfConstants;
import ext.lib.doc.util.DcfDocumentUtil;
import ext.lib.html.ruby.HtmlRubyParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import nlc.lib.doc.DcfParagraph;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfRectangle2D;
import nlc.lib.doc.shape.DcfTextShape;

public class DcfTextRenderer
extends BcLoggableObject
implements Cloneable {
    protected DcfShapeRenderer shapeRenderer;
    protected HtmlRubyParser htmlRubyParser;

    public DcfTextRenderer(DcfShapeRenderer shapeRenderer) {
        this.shapeRenderer = shapeRenderer;
        this.htmlRubyParser = new HtmlRubyParser();
    }

    public double calcHeight(double rowHeight, double rowGap, int rowCount) throws Exception {
        if (rowCount <= 1) {
            return rowHeight * (double)rowCount;
        }
        return rowHeight * (double)rowCount + rowGap * (double)(rowCount - 1);
    }

    public DcfParseResult parse(DcfTextShape textShape, double bx, double by) throws Exception {
        DcfRenderingText renderingText;
        int i;
        DcfRectangle2D region = new DcfRectangle2D();
        region.x = bx + textShape.getX() + textShape.padding;
        region.y = by + textShape.getY() + textShape.padding;
        region.width = textShape.getRectangle().width - textShape.padding * 2.0;
        if (region.width < 0.0) {
            region.width = 0.0;
        }
        region.height = textShape.getRectangle().height - textShape.padding * 2.0;
        if (region.height < 0.0) {
            region.height = 0.0;
        }
        DcfParseResult parseResult = new DcfParseResult();
        parseResult.region = region;
        ArrayList<DcfParagraph> paragraphList1 = new ArrayList<DcfParagraph>();
        if (!BcCollectionUtil.isEmpty(textShape.paragraphList)) {
            paragraphList1.addAll(textShape.paragraphList);
        } else if (!BcStringUtil.isEmpty(textShape.value)) {
            DcfParagraph paragraph = new DcfParagraph();
            paragraph.text = textShape.value;
            paragraph.font = textShape.font;
            paragraph.color = textShape.textColor;
            if (textShape.hasUnderLine) {
                paragraph.underLineType = DcfConstants.UnderLineType.single.id;
            }
            paragraph.underLineWeight = 0.2f;
            paragraph.underLineColor = paragraph.color;
            paragraphList1.add(paragraph);
        }
        if (BcCollectionUtil.isEmpty(paragraphList1)) {
            return parseResult;
        }
        ArrayList<DcfParagraph> paragraphList2 = new ArrayList<DcfParagraph>();
        int i2 = 0;
        while (i2 < paragraphList1.size()) {
            DcfParagraph paragraph1 = (DcfParagraph)paragraphList1.get(i2);
            if (!BcStringUtil.isEmpty(paragraph1.text)) {
                String convertedText = DcfDocumentUtil.decode(paragraph1.text);
                List<String> lineList = BcStringUtil.lineSeparete2(convertedText);
                int j = 0;
                while (j < lineList.size()) {
                    DcfParagraph paragraph2 = new DcfParagraph();
                    paragraph2.text = lineList.get(j);
                    paragraph2.font = paragraph1.font;
                    paragraph2.color = paragraph1.color;
                    paragraph2.underLineType = paragraph1.underLineType;
                    paragraph2.underLineWeight = paragraph1.underLineWeight;
                    paragraph2.underLineColor = paragraph2.color;
                    paragraph2.newLine = false;
                    if (paragraphList2.size() <= 0) {
                        paragraph2.newLine = true;
                    } else if (j > 0) {
                        paragraph2.newLine = true;
                    }
                    paragraphList2.add(paragraph2);
                    ++j;
                }
            }
            ++i2;
        }
        if (BcCollectionUtil.isEmpty(paragraphList2)) {
            return parseResult;
        }
        parseResult.fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        if (textShape.rubyEnabled) {
            TextLayout rubyTextLayoutSample = DcfDocumentUtil.createDefaultTextLayout(textShape.rubyFont, parseResult.fontRenderContext);
            parseResult.rubyHeight = rubyTextLayoutSample.getAscent() + rubyTextLayoutSample.getDescent();
        }
        double restWidth = region.width;
        DcfRenderingRow renderingRow = null;
        if (textShape.wrapText) {
            i = 0;
            while (i < paragraphList2.size()) {
                DcfParagraph paragraph = (DcfParagraph)paragraphList2.get(i);
                if (paragraph.newLine) {
                    renderingRow = new DcfRenderingRow();
                    parseResult.rowList.add(renderingRow);
                    restWidth = region.width;
                }
                if (BcStringUtil.isEmpty(paragraph.text)) {
                    this.setEmptyRow(renderingRow, paragraph, parseResult.fontRenderContext);
                } else {
                    DcfTextParseData textParseData = this.parse_L2(parseResult.fontRenderContext, paragraph, region.width, restWidth);
                    int j = 0;
                    while (j < textParseData.renderingTextList.size()) {
                        DcfRenderingText renderingText2 = textParseData.renderingTextList.get(j);
                        if (j == 0) {
                            renderingRow.renderingTextList.add(renderingText2);
                        } else {
                            renderingRow = new DcfRenderingRow();
                            parseResult.rowList.add(renderingRow);
                            renderingRow.renderingTextList.add(renderingText2);
                        }
                        ++j;
                    }
                    restWidth = textParseData.hasNext ? textParseData.restWidth : region.width;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < paragraphList2.size()) {
                DcfParagraph paragraph = (DcfParagraph)paragraphList2.get(i);
                if (paragraph.newLine) {
                    renderingRow = new DcfRenderingRow();
                    parseResult.rowList.add(renderingRow);
                }
                if (BcStringUtil.isEmpty(paragraph.text)) {
                    this.setEmptyRow(renderingRow, paragraph, parseResult.fontRenderContext);
                } else {
                    renderingText = new DcfRenderingText();
                    renderingText.text = paragraph.text;
                    renderingText.font = paragraph.font;
                    renderingText.textLayout = new TextLayout(paragraph.text, paragraph.font, parseResult.fontRenderContext);
                    renderingText.color = paragraph.color;
                    renderingText.underLineType = paragraph.underLineType;
                    renderingText.underLineWeight = paragraph.underLineWeight;
                    renderingText.underLineColor = paragraph.underLineColor;
                    renderingRow.renderingTextList.add(renderingText);
                }
                ++i;
            }
        }
        i = 0;
        while (i < parseResult.rowList.size()) {
            renderingRow = parseResult.rowList.get(i);
            int j = 0;
            while (j < renderingRow.renderingTextList.size()) {
                renderingText = renderingRow.renderingTextList.get(j);
                renderingRow.ascent = Math.max(renderingRow.ascent, (double)renderingText.textLayout.getAscent());
                renderingRow.descent = Math.max(renderingRow.descent, (double)renderingText.textLayout.getDescent());
                renderingRow.leading = Math.max(renderingRow.leading, (double)renderingText.textLayout.getLeading());
                ++j;
            }
            parseResult.renderingHeigh += renderingRow.ascent;
            parseResult.renderingHeigh += renderingRow.descent;
            parseResult.renderingHeigh += renderingRow.leading;
            if (i > 0) {
                parseResult.renderingHeigh += textShape.rowGap;
            }
            ++i;
        }
        return parseResult;
    }

    public DcfTextParseData parse_L2(FontRenderContext fontRenderContext, DcfParagraph paragraph, double regionWidth, double restWidth1) throws Exception {
        double wrappingWidth;
        DcfTextParseData textParseData = new DcfTextParseData();
        textParseData.restWidth = restWidth1;
        AttributedString attributedString = new AttributedString(paragraph.text);
        attributedString.addAttribute(TextAttribute.FONT, paragraph.font, 0, paragraph.text.length());
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
        lineBreakMeasurer.setPosition(0);
        double restWidth2 = wrappingWidth = restWidth1;
        boolean offsetLimit = true;
        ArrayList<String> partist = new ArrayList<String>();
        while (lineBreakMeasurer.getPosition() < paragraph.text.length()) {
            int startPos = lineBreakMeasurer.getPosition();
            TextLayout textLayout = lineBreakMeasurer.nextLayout((float)wrappingWidth, paragraph.text.length(), false);
            if (textLayout == null) {
                textParseData.hasNext = true;
                break;
            }
            String part = paragraph.text.substring(startPos, lineBreakMeasurer.getPosition());
            restWidth2 -= textLayout.getBounds().getWidth();
            if (textLayout.getBounds().getWidth() > wrappingWidth) {
                if (partist.size() > 0) {
                    DcfRenderingText renderingText = new DcfRenderingText();
                    renderingText.text = BcStringUtil.marge(partist).toString();
                    renderingText.font = paragraph.font;
                    renderingText.textLayout = new TextLayout(renderingText.text, paragraph.font, fontRenderContext);
                    renderingText.color = paragraph.color;
                    renderingText.underLineType = paragraph.underLineType;
                    renderingText.underLineWeight = paragraph.underLineWeight;
                    renderingText.underLineColor = paragraph.underLineColor;
                    textParseData.renderingTextList.add(renderingText);
                }
                if (regionWidth <= wrappingWidth) break;
                lineBreakMeasurer.setPosition(startPos);
                wrappingWidth = regionWidth;
                restWidth2 = regionWidth;
                partist.clear();
                continue;
            }
            wrappingWidth = restWidth2;
            partist.add(part);
        }
        if (partist.size() > 0) {
            DcfRenderingText renderingText = new DcfRenderingText();
            renderingText.text = BcStringUtil.marge(partist).toString();
            renderingText.font = paragraph.font;
            renderingText.textLayout = new TextLayout(renderingText.text, paragraph.font, fontRenderContext);
            renderingText.color = paragraph.color;
            renderingText.underLineType = paragraph.underLineType;
            renderingText.underLineWeight = paragraph.underLineWeight;
            renderingText.underLineColor = paragraph.underLineColor;
            textParseData.renderingTextList.add(renderingText);
        }
        textParseData.restWidth = restWidth2;
        return textParseData;
    }

    public void setEmptyRow(DcfRenderingRow renderingRow, DcfParagraph paragraph, FontRenderContext fontRenderContext) throws Exception {
        TextLayout textLayout = new TextLayout(BcStringUtil.SPACE_STR, paragraph.font, fontRenderContext);
        renderingRow.ascent = textLayout.getAscent();
        renderingRow.descent = textLayout.getDescent();
        renderingRow.leading = textLayout.getLeading();
    }

    public DcfTextShape fontSmall(DcfTextShape textShape) throws Exception {
        if (textShape.font.getSize() > 1) {
            textShape.font = new Font(textShape.font.getFontName(), textShape.font.getStyle(), textShape.font.getSize() - 1);
        } else {
            textShape.value = null;
        }
        if (BcCollectionUtil.isEmpty(textShape.paragraphList)) {
            return textShape;
        }
        int paragraphCnt = textShape.paragraphList.size();
        int i = 0;
        while (i < paragraphCnt) {
            int index = paragraphCnt - i - 1;
            DcfParagraph paragraph = textShape.paragraphList.get(index);
            if (paragraph.font.getSize() > 1) {
                paragraph.font = new Font(paragraph.font.getFontName(), paragraph.font.getStyle(), paragraph.font.getSize() - 1);
            } else {
                textShape.paragraphList.remove(index);
            }
            ++i;
        }
        return textShape;
    }

    public void drawTextShape(Graphics2D g2d, double bx, double by, DcfTextShape textShape) throws Exception {
        double cy1;
        DcfTextShape textShapeWk = textShape;
        DcfParseResult parseResult = null;
        int tryCnt = 0;
        while (true) {
            ++tryCnt;
            if (BcStringUtil.isEmpty(textShapeWk.value) && BcCollectionUtil.isEmpty(textShapeWk.paragraphList)) {
                return;
            }
            parseResult = this.parse(textShapeWk, bx, by);
            if (BcCollectionUtil.isEmpty(parseResult.rowList)) {
                return;
            }
            if (!textShapeWk.shrinkToFit) break;
            boolean doReduction = false;
            double rowWidthMax = 0.0;
            int i = 0;
            while (i < parseResult.rowList.size()) {
                DcfRenderingRow renderingRow = parseResult.rowList.get(i);
                double rowWidth = 0.0;
                int j = 0;
                while (j < renderingRow.renderingTextList.size()) {
                    DcfRenderingText renderingText = renderingRow.renderingTextList.get(j);
                    rowWidth += (double)renderingText.textLayout.getAdvance();
                    ++j;
                }
                rowWidthMax = Math.max(rowWidthMax, rowWidth);
                ++i;
            }
            if (parseResult.region.width < rowWidthMax) {
                doReduction = true;
            }
            if (!doReduction) break;
            if (tryCnt == 1) {
                textShapeWk = BcCloneUtil.createClone(textShapeWk);
            }
            textShapeWk = this.fontSmall(textShapeWk);
        }
        double ddy = 0.0;
        if (textShapeWk.verticalAlign == 0) {
            ddy = (parseResult.region.height - parseResult.renderingHeigh) / 2.0;
        } else if (textShapeWk.verticalAlign == 3) {
            ddy = parseResult.region.height - parseResult.renderingHeigh;
        }
        double cy2 = cy1 = parseResult.region.y + ddy;
        if (textShapeWk.doClip) {
            g2d.clip(parseResult.region);
        }
        int i = 0;
        while (i < parseResult.rowList.size()) {
            DcfRenderingRow renderingRow = parseResult.rowList.get(i);
            double rowHeight = renderingRow.ascent + renderingRow.descent + renderingRow.leading;
            cy2 += renderingRow.ascent;
            int charCnt = 0;
            double rowWidth = 0.0;
            int j = 0;
            while (j < renderingRow.renderingTextList.size()) {
                DcfRenderingText renderingText = renderingRow.renderingTextList.get(j);
                charCnt += renderingText.text.length();
                rowWidth += (double)renderingText.textLayout.getAdvance();
                ++j;
            }
            if (textShape.equalDistance) {
                double cx1;
                double distance = (parseResult.region.width - rowWidth) / (double)(charCnt - 1);
                double cx2 = cx1 = parseResult.region.x;
                if (textShape.hatchingDot > 0.0) {
                    this.drawHatchingDot(g2d, cx1, cy1, parseResult.region.width, rowHeight, textShape.hatchingDot, textShape.hatchingConcentration, textShape.hatchingColor);
                }
                int j2 = 0;
                while (j2 < renderingRow.renderingTextList.size()) {
                    DcfRenderingText renderingText = renderingRow.renderingTextList.get(j2);
                    g2d.setColor(renderingText.color);
                    g2d.setFont(renderingText.font);
                    int k = 0;
                    while (k < renderingText.text.length()) {
                        char aChar = renderingText.text.charAt(k);
                        if (k > 0) {
                            cx2 += distance;
                        }
                        g2d.drawString(Character.toString(aChar), (float)cx2, (float)cy2);
                        TextLayout textLayout2 = new TextLayout(Character.toString(aChar), renderingText.font, parseResult.fontRenderContext);
                        cx2 += (double)textLayout2.getAdvance();
                        ++k;
                    }
                    this.drawUnderLine(g2d, cx1, cy2, cx2, renderingText);
                    ++j2;
                }
            } else {
                double cx1 = parseResult.region.x;
                if (textShapeWk.horizontalAlign == 0) {
                    cx1 = parseResult.region.x + (parseResult.region.width - rowWidth) / 2.0;
                } else if (textShapeWk.horizontalAlign == 4) {
                    cx1 = parseResult.region.x + parseResult.region.width - rowWidth;
                }
                double cx2 = cx1;
                int j3 = 0;
                while (j3 < renderingRow.renderingTextList.size()) {
                    if (textShape.hatchingDot > 0.0) {
                        this.drawHatchingDot(g2d, cx2, cy1, rowWidth, rowHeight, textShape.hatchingDot, textShape.hatchingConcentration, textShape.hatchingColor);
                    }
                    DcfRenderingText renderingText = renderingRow.renderingTextList.get(j3);
                    g2d.setColor(renderingText.color);
                    g2d.setFont(renderingText.font);
                    AffineTransform affineTransformBak = g2d.getTransform();
                    if (textShape.textDegrees != 0.0) {
                        Point2D.Double point2D = this.calcRectangCenter(bx + textShape.getX(), by + textShape.getY(), textShape.getRectangle().width, textShape.getRectangle().height);
                        AffineTransform affineTransform2 = (AffineTransform)affineTransformBak.clone();
                        affineTransform2.rotate(Math.toRadians(textShape.textDegrees), point2D.x, point2D.y);
                        g2d.setTransform(affineTransform2);
                    }
                    g2d.drawString(renderingText.text, (float)cx2, (float)cy2);
                    this.drawUnderLine(g2d, cx2, cy2, cx2 + (double)renderingText.textLayout.getAdvance(), renderingText);
                    g2d.setTransform(affineTransformBak);
                    cx2 += (double)renderingText.textLayout.getAdvance();
                    ++j3;
                }
            }
            cy2 += renderingRow.descent;
            cy2 += renderingRow.leading;
            cy2 += textShapeWk.rowGap;
            ++i;
        }
    }

    public void drawUnderLine(Graphics2D g2d, double dx1, double dy1, double dx2, DcfRenderingText renderingText) throws Exception {
        if (renderingText.underLineType == DcfConstants.UnderLineType.none.id) {
            return;
        }
        double yAdjustment = renderingText.textLayout.getDescent() / 2.0f;
        DcfLineShape lineShape = new DcfLineShape();
        lineShape.setX(dx1);
        lineShape.setY(dy1 + (double)renderingText.textLayout.getDescent() + (double)renderingText.textLayout.getLeading() + yAdjustment);
        lineShape.getLine().x2 = dx2;
        lineShape.getLine().y2 = lineShape.getY();
        lineShape.lineWidth = renderingText.underLineWeight;
        lineShape.lineColor = renderingText.underLineColor;
        this.shapeRenderer.drawLineShape(g2d, 0.0, 0.0, lineShape);
    }

    public void drawHatchingDot(Graphics2D g2d, double bx, double by, double bw, double bh, double hatchingDot, double hatchingConcentration, Color hatchingColor) throws Exception {
        double rx = bw / hatchingConcentration + 1.0;
        double ry = bh / hatchingConcentration + 1.0;
        if (hatchingColor != null) {
            g2d.setColor(hatchingColor);
        } else {
            g2d.setColor(Color.BLACK);
        }
        int i = 0;
        while ((double)i < rx) {
            double px = bx + (double)i * hatchingConcentration;
            int j = 0;
            while ((double)j < ry) {
                if (BcMath.isEven(i) == BcMath.isEven(j)) {
                    double py = by + (double)j * hatchingConcentration;
                    Rectangle2D.Double rectangle2 = new Rectangle2D.Double(px, py, hatchingDot, hatchingDot);
                    g2d.fill(rectangle2);
                }
                ++j;
            }
            ++i;
        }
    }

    public void drawMultiFontTextRuby_L2(Graphics2D g2d, double bx, double by, int rowNum, double rowHeight, double ddY, double rubyHeight, DcfTextShape textShape, FontRenderContext fontRenderContext, List<DcfRenderingText> renderingTextList) throws Exception {
        int i = 0;
        while (i < renderingTextList.size()) {
            DcfRenderingText renderingText = renderingTextList.get(i);
            if (textShape.wrapText) {
                this.drawTextWithWrap(g2d, bx, by, rowNum + i, rowHeight, ddY, rubyHeight, textShape, fontRenderContext, renderingText.text, renderingText.ruby);
            } else {
                this.drawTextWithoutWrap(g2d, bx, by, rowNum + i, rowHeight, ddY, rubyHeight, textShape, fontRenderContext, renderingText.text, renderingText.ruby);
            }
            ++i;
        }
    }

    public void drawTextWithWrap(Graphics2D g2d, double bx, double by, int rowNum, double rowHeight, double ddY, double rubyHeight, DcfTextShape textShape, FontRenderContext fontRenderContext, String sentence, String ruby) throws Exception {
        double drawAriaWidth = textShape.getRectangle().width - textShape.padding * 2.0;
        double xPos = 0.0;
        AttributedString attributedString = new AttributedString(sentence);
        attributedString.addAttribute(TextAttribute.FONT, textShape.font, 0, sentence.length());
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
        lineBreakMeasurer.setPosition(0);
        int tmpCnt = 0;
        while (lineBreakMeasurer.getPosition() < sentence.length()) {
            if (++tmpCnt > 1) {
                ++rowNum;
                xPos = 0.0;
            }
            if (g2d != null && this.calcHeight(rowHeight, textShape.rowGap, rowNum) > textShape.getRectangle().height) break;
            if (drawAriaWidth - xPos <= 0.0) continue;
            int startPos = lineBreakMeasurer.getPosition();
            TextLayout textLayout = lineBreakMeasurer.nextLayout((float)(drawAriaWidth - xPos));
            if (textLayout == null) break;
            String drawText = sentence.substring(startPos, lineBreakMeasurer.getPosition());
            this.drawTextWithoutWrap_L2(g2d, bx, by, rowNum, rowHeight, ddY, rubyHeight, textShape, fontRenderContext, drawText, ruby, textLayout);
            xPos += (double)textLayout.getAdvance();
        }
    }

    public void drawTextWithoutWrap(Graphics2D g2d, double bx, double by, int rowNum, double rowHeight, double ddY, double rubyHeight, DcfTextShape textShape, FontRenderContext fontRenderContext, String sentence, String ruby) throws Exception {
        if (textShape.shrinkToFit) {
            TextLayout textLayout1 = new TextLayout(sentence, textShape.font, fontRenderContext);
            double fontHeight1 = DcfShapeRenderingUtil.getHeight(textLayout1);
            DcfTextShape textShape2 = (DcfTextShape)textShape.clone();
            double drawAriaWidth = textShape2.getRectangle().width - textShape2.padding * 2.0;
            textShape2.font = this.getShrinkToFitFont(drawAriaWidth, rowHeight, textShape.font, sentence);
            if (textShape2.font != null) {
                TextLayout textLayout2 = new TextLayout(sentence, textShape2.font, fontRenderContext);
                double fontHeight2 = DcfShapeRenderingUtil.getHeight(textLayout2);
                double gap = fontHeight1 - fontHeight2;
                if (textShape.verticalAlign == 0) {
                    ddY -= gap / 2.0;
                } else if (textShape.verticalAlign != 3) {
                    ddY -= gap;
                }
                this.drawTextWithoutWrap_L2(g2d, bx, by, rowNum, rowHeight, ddY, rubyHeight, textShape2, fontRenderContext, sentence, ruby, textLayout2);
            }
        } else {
            TextLayout textLayout = new TextLayout(sentence, textShape.font, fontRenderContext);
            this.drawTextWithoutWrap_L2(g2d, bx, by, rowNum, rowHeight, ddY, rubyHeight, textShape, fontRenderContext, sentence, ruby, textLayout);
        }
    }

    public void drawTextWithoutWrap_L2(Graphics2D g2d, double bx, double by, int rowNum, double rowHeight, double ddY, double rubyHeight, DcfTextShape textShape, FontRenderContext fontRenderContext, String drawText, String ruby, TextLayout textLayout) throws Exception {
        double drawAriaWidth = textShape.getRectangle().width - textShape.padding * 2.0;
        double xPos = 0.0;
        if (textShape.rubyEnabled) {
            if (g2d != null) {
                g2d.setFont(textShape.rubyFont);
                g2d.setColor(textShape.rubyColor);
            }
            if (!BcStringUtil.isEmpty(ruby)) {
                TextLayout rubyTextLayout = new TextLayout(ruby, textShape.rubyFont, fontRenderContext);
                double xGap = (textLayout.getAdvance() - rubyTextLayout.getAdvance()) / 2.0f;
                if (g2d != null) {
                    double tmpX = textShape.getX() + textShape.padding + xPos + xGap;
                    double tmpY = textShape.getY() + textShape.padding + ddY + (rowHeight + textShape.rowGap) * (double)(rowNum - 1) + rubyHeight;
                    g2d.drawString(ruby, (float)(bx + tmpX), (float)(by + tmpY));
                }
            }
        }
        if (g2d != null) {
            g2d.setFont(textShape.font);
            g2d.setColor(textShape.textColor);
            double tmpX = 0.0;
            tmpX = textShape.horizontalAlign == 0 ? textShape.getX() + (textShape.getRectangle().width - (double)textLayout.getVisibleAdvance()) / 2.0 : (textShape.horizontalAlign == 4 ? textShape.getX() + textShape.getRectangle().width - (double)textLayout.getVisibleAdvance() - textShape.padding : textShape.getX() + textShape.padding + xPos);
            double tmpY = textShape.getY() + textShape.padding + ddY + (rowHeight + textShape.rowGap) * (double)(rowNum - 1) + rowHeight;
            if (textShape.equalDistance) {
                double textWidthSum = 0.0;
                int i = 0;
                while (i < drawText.length()) {
                    char aChar = drawText.charAt(i);
                    TextLayout textLayout2 = new TextLayout(Character.toString(aChar), textShape.font, fontRenderContext);
                    textWidthSum += (double)textLayout2.getAdvance();
                    ++i;
                }
                if (drawText.length() == 1) {
                    tmpX = textShape.getX() + (textShape.getRectangle().width - textLayout.getBounds().getWidth()) / 2.0;
                    g2d.drawString(drawText, (float)(bx + tmpX), (float)(by + tmpY));
                } else {
                    double distance = (drawAriaWidth - textWidthSum) / (double)(drawText.length() - 1);
                    tmpX = textShape.getX() + textShape.padding;
                    int i2 = 0;
                    while (i2 < drawText.length()) {
                        char aChar = drawText.charAt(i2);
                        g2d.drawString(Character.toString(aChar), (float)(bx + tmpX), (float)(by + tmpY));
                        TextLayout textLayout2 = new TextLayout(Character.toString(aChar), textShape.font, fontRenderContext);
                        tmpX += (double)textLayout2.getAdvance() + distance;
                        ++i2;
                    }
                }
            } else if (textShape.textDegrees != 0.0) {
                AffineTransform affineTransform1 = g2d.getTransform();
                Point2D.Double point2D = this.calcRectangCenter(bx + textShape.getX(), by + textShape.getY(), textShape.getRectangle().width, textShape.getRectangle().height);
                AffineTransform affineTransform2 = (AffineTransform)affineTransform1.clone();
                affineTransform2.rotate(Math.toRadians(textShape.textDegrees), point2D.x, point2D.y);
                g2d.setTransform(affineTransform2);
                g2d.drawString(drawText, (float)(point2D.x + 5.0), (float)(point2D.y - 3.0));
                g2d.setTransform(affineTransform1);
            } else {
                g2d.drawString(drawText, (float)(bx + tmpX), (float)(by + tmpY));
                if (textShape.hatchingDot > 0.0) {
                    double hsX = bx + tmpX;
                    double hsY = by + tmpY - rowHeight;
                    double hsW = textLayout.getVisibleAdvance();
                    double hsH = rowHeight;
                    double rx = hsW / textShape.hatchingConcentration + 1.0;
                    double ry = hsH / textShape.hatchingConcentration + 1.0;
                    if (textShape.hatchingColor != null) {
                        g2d.setColor(textShape.hatchingColor);
                    } else {
                        g2d.setColor(Color.BLACK);
                    }
                    int i = 0;
                    while ((double)i < rx) {
                        double px = hsX + (double)i * textShape.hatchingConcentration;
                        int j = 0;
                        while ((double)j < ry) {
                            if (BcMath.isEven(i) == BcMath.isEven(j)) {
                                double py = hsY + (double)j * textShape.hatchingConcentration;
                                Rectangle2D.Double rectangle2 = new Rectangle2D.Double(px, py, textShape.hatchingDot, textShape.hatchingDot);
                                g2d.fill(rectangle2);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            if (textShape.hasUnderLine) {
                DcfLineShape lineShape = new DcfLineShape();
                lineShape.setX(tmpX);
                lineShape.setY(tmpY + 1.0);
                lineShape.getLine().x2 = lineShape.getX() + (double)textLayout.getAdvance();
                lineShape.getLine().y2 = lineShape.getY();
                lineShape.lineWidth = 0.2f;
                this.shapeRenderer.drawLineShape(g2d, bx, by, lineShape);
            }
        }
        xPos += (double)textLayout.getAdvance();
    }

    public Point2D.Double calcRectangCenter(double x, double y, double width, double height) throws Exception {
        Point2D.Double point2D = new Point2D.Double();
        point2D.setLocation(x + width / 2.0, y + height / 2.0);
        return point2D;
    }

    public Font getShrinkToFitFont(double areaWidth, double areaHeight, Font font1, String sentence) throws Exception {
        boolean b;
        Font font2 = font1;
        while (!(b = this.getShrinkToFitFont_L2(areaWidth, areaHeight, font2, sentence))) {
            if (font2.getSize() <= 1) {
                font2 = null;
                break;
            }
            font2 = new Font(font2.getName(), font2.getStyle(), font2.getSize() - 1);
        }
        return font2;
    }

    public boolean getShrinkToFitFont_L2(double areaWidth, double areaHeight, Font font1, String sentence) throws Exception {
        AttributedString attributedString = new AttributedString(sentence);
        attributedString.addAttribute(TextAttribute.FONT, font1, 0, sentence.length());
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
        lineBreakMeasurer.setPosition(0);
        double y = 0.0;
        boolean res = true;
        while (lineBreakMeasurer.getPosition() < sentence.length()) {
            TextLayout textLayout;
            int startPos = lineBreakMeasurer.getPosition();
            if (startPos > 0) {
                res = false;
            }
            if ((textLayout = lineBreakMeasurer.nextLayout((float)areaWidth)) == null) break;
            y += (double)textLayout.getAscent();
            y += (double)textLayout.getDescent();
            y += (double)textLayout.getLeading();
            String string = sentence.substring(startPos, lineBreakMeasurer.getPosition());
        }
        if (y > areaHeight) {
            res = false;
        }
        return res;
    }

    class DcfTextParseData {
        List<DcfRenderingText> renderingTextList = new ArrayList<DcfRenderingText>();
        double restWidth;
        boolean hasNext = false;

        DcfTextParseData() {
        }
    }
}

