/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.lib.datasource.AbstractSession;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.context.SqlContext;
import java.util.Locale;

public class DtsSession
extends AbstractSession {
    private DtsSessionFactory sessionFactory;
    private Locale locale;
    private DtsConnectionManager connectionManager;
    private SqlContext sqlContext;
    private SqlConnection sqlConn;

    public DtsSession(DtsSessionFactory sessionFactory) {
        this.startTime = System.currentTimeMillis();
        this.sessionFactory = sessionFactory;
    }

    public DtsSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(DtsConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public void setSqlContext(SqlContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public SqlConnection getConnection() throws Exception {
        if (this.sqlConn == null) {
            this.sqlConn = this.connectionManager.getConnection();
        }
        this.sqlConn.setOwner(this.owner);
        return this.sqlConn;
    }

    public void setConnection(SqlConnection sqlConn) {
        this.sqlConn = sqlConn;
    }

    public boolean hasConnection() {
        return this.sqlConn != null;
    }

    public void commit() throws Exception {
        if (this.sqlConn != null && !this.sqlConn.getAutoCommit()) {
            this.sqlConn.commit();
        }
    }

    public void rollback() throws Exception {
        if (this.sqlConn != null) {
            this.sqlConn.rollback();
        } else {
            this.getLogger().warning("sqlCon=" + this.sqlConn);
        }
    }

    public void desturuct() throws Exception {
        if (this.sqlConn != null) {
            if (!this.sqlConn.isClosed()) {
                try {
                    this.sqlConn.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
            this.sqlConn = null;
        }
        this.locale = null;
        this.connectionManager = null;
        this.sqlContext = null;
        if (this.sessionFactory != null) {
            this.sessionFactory.getSessionList().remove(this);
        }
        this.sessionFactory = null;
    }

    @Override
    public void close() {
        try {
            this.desturuct();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }
}

