/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcAscii;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;

public final class BcUnicode {
    public static final char SEMICOLON = ';';
    public static final char LESS_THAN = '<';
    public static final char EQUALS_SIGN = '=';
    public static final char GREATER_THAN = '>';
    public static final char QUESTION_MARK = '?';
    public static final char MIDDLE_DOT = '\u00b7';
    public static final char OPEN_BOX = '\u2423';
    public static final char \u7f6b\u7dda1 = '\u2500';
    public static final char \u7f6b\u7dda2 = '\u2501';
    public static final char FULLWIDTH_SPACE = '\u3000';
    public static final String FULLWIDTH_SPACE_STR = Character.toString(Unicode.FULLWIDTH_SPACE.char_);
    public static final char FULLWIDTH_\u4e2d\u9ed2\u70b9 = '\u30fb';
    public static final char KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = '\u30fc';
    public static final char FULLWIDTH_\u3044\u3061 = '\u4e00';
    public static final char FULLWIDTH_EXCLAMATION_MARK = '\uff01';
    public static final char FULLWIDTH_SOLIDUS = '\uff0f';
    public static final char FULLWIDTH_COLON = '\uff1a';
    public static final char FULLWIDTH_SEMICOLON = '\uff1b';
    public static final char FULLWIDTH_\u534a\u89d2\u9577\u97f3 = '\uff70';

    private BcUnicode() {
    }

    public static String replace(CharacterConverter characterConverter, String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return str;
        }
        int i = 0;
        while (i < characterConverter.getCount()) {
            Unicode newUnicode = characterConverter.getNewUnicode(i);
            Unicode[] oldUnicodes = characterConverter.getOldUnicodes(i);
            int j = 0;
            while (j < oldUnicodes.length) {
                str = str.replace(oldUnicodes[j].char_, newUnicode.char_);
                ++j;
            }
            ++i;
        }
        return str;
    }

    public static enum Change implements CharacterConverter
    {
        SPACE(Unicode.SPACE, Unicode.noBreakSpace),
        WAVE_DASH(Unicode.WAVE_DASH, Unicode.ILDE_OPERATOR, Unicode.REVERSED_TILDE, Unicode.INVERTED_LAZY_S, Unicode.SIGN_WAVE, Unicode.FULLWIDTH_TILDE);

        public final Unicode newUnicode;
        public final Unicode[] oldUnicodes;

        private Change(Unicode newUnicode, Unicode ... oldUnicodes) {
            this.newUnicode = newUnicode;
            this.oldUnicodes = oldUnicodes;
        }

        @Override
        public int getCount() {
            return Change.values().length;
        }

        @Override
        public Unicode getNewUnicode(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.newUnicode;
        }

        @Override
        public Unicode[] getOldUnicodes(int index) {
            Change characterConverter = BcLangUtil.getEnumByOrdinal(Change.class, index);
            return characterConverter.oldUnicodes;
        }
    }

    public static interface CharacterConverter {
        public int getCount();

        public Unicode getNewUnicode(int var1);

        public Unicode[] getOldUnicodes(int var1);
    }

    public static enum Unicode {
        NULL(BcAscii.Ascii.NULL.code, BcAscii.Ascii.NULL.code, "NULL"),
        BS(8, (byte)8, "\u5f8c\u9000"),
        HT(9, (byte)9, "\u6c34\u5e73\u30bf\u30d6"),
        LF(10, (byte)10, "\u6539\u884c"),
        FF(12, (byte)12, "\u6539\u30da\u30fc\u30b8"),
        CR(13, (byte)13, "\u5fa9\u5e30"),
        ESC(27, (byte)27, "ESC"),
        SPACE(32, (byte)32, "\u30b9\u30da\u30fc\u30b9"),
        exclamationMark(33, (byte)33, "\u611f\u5606\u7b26"),
        quotationMark(34, (byte)34, "\u30c0\u30d6\u30eb\u30af\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3"),
        numberSign(35, (byte)35, "\u30b7\u30e3\u30fc\u30d7"),
        dollarSign(36, (byte)36, "\u30c0\u30e9\u30fc"),
        percentSign(37, (byte)37, "\u30d1\u30fc\u30bb\u30f3\u30c8"),
        ampersand(38, (byte)38, "\u30a2\u30f3\u30d1\u30b5\u30f3\u30c9"),
        apostrophe(39, (byte)39, "\u30c0\u30d6\u30eb\u30af\u30a9\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3"),
        leftParenthesis(40, (byte)40, "\u5c0f\u62ec\u5f27\u958b\u304d"),
        rightParenthesis(41, (byte)41, "\u5c0f\u62ec\u5f27\u9589\u3058"),
        asterisk(42, (byte)42, "\u30a2\u30b9\u30bf\u30ea\u30b9\u30af"),
        plusSign(43, (byte)43, "\u30d7\u30e9\u30b9"),
        COMMA(44, (byte)44, "\u30ab\u30f3\u30de"),
        HYPHEN(45, (byte)45, "\u30cf\u30a4\u30d5\u30f3"),
        PERIOD(46, (byte)46, "\u30d4\u30ea\u30aa\u30c9"),
        SOLIDUS(47, (byte)47, "\u30b9\u30e9\u30c3\u30b7\u30e5"),
        DEL(127, (byte)127, "Delete"),
        number_0(48, (byte)48, "zero"),
        number_9(57, (byte)57, "nine"),
        COLON(58, (byte)58, "\u30b3\u30ed\u30f3"),
        semiColon(59, (byte)59, "\u30bb\u30df\u30b3\u30ed\u30f3"),
        lessThan(60, (byte)60, "\u5c0f\u306a\u308a"),
        equalSsign(61, (byte)61, "\u30a4\u30b3\u30fc\u30eb"),
        greaterThan(62, (byte)62, "\u5927\u306a\u308a"),
        questionMark(63, (byte)63, "\u30af\u30a8\u30b9\u30c1\u30e7\u30f3"),
        A(65, (byte)65, "A"),
        Z(90, (byte)90, "Z"),
        leftSquareBracket(91, (byte)91, "\u5927\u62ec\u5f27\u958b\u304d"),
        reverseSolidus(92, (byte)92, "\u30d0\u30c3\u30af\u30b9\u30e9\u30c3\u30b7\u30e5"),
        rightSquareBracket(93, (byte)93, "\u5927\u62ec\u5f27\u9589\u3058"),
        caret(94, (byte)94, "\u30ad\u30e3\u30ec\u30c3\u30c8"),
        horizontalBar(95, (byte)95, "\u30a2\u30f3\u30c0\u30fc\u30b9\u30b3\u30a2"),
        acuteAccent(96, (byte)96, "\u30a2\u30ad\u30e5\u30fc\u30c8\u30fb\u30a2\u30af\u30bb\u30f3\u30c8"),
        a(97, (byte)97, "a"),
        z(122, (byte)122, "z"),
        leftCurlyBrace(123, (byte)123, "\u4e2d\u62ec\u5f27\u958b\u304d"),
        verticalBar(124, (byte)124, "\u30d1\u30a4\u30d7"),
        rightCurlyBrace(125, (byte)125, "\u4e2d\u62ec\u5f27\u9589\u3058"),
        tilde(126, (byte)126, "\u30c1\u30eb\u30c0"),
        noBreakSpace(10, (byte)10, "&nbsp"),
        FULLWIDTH_HYPHEN(8208, null, "\u5168\u89d2\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_NON_BREAKING_HYPHEN(8209, null, "\u5168\u89d2BREAKING\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_FIGURE_DASH(8210, null, "\u5168\u89d2\u30d5\u30a3\u30ae\u30e5\u30a2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_EN_DASH(8211, null, "\u5168\u89d2\u4e8c\u5206\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_EM_DASH(8212, null, "\u5168\u89d2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_HORIZONTAL_BAR(8213, null, "\u5168\u89d2\u30db\u30ea\u30be\u30f3\u30bf\u30eb\u30d0\u30fc"),
        FULLWIDTH_MINUS_SIGN(8722, null, "\u5168\u89d2\u30de\u30a4\u30ca\u30b9"),
        ILDE_OPERATOR(8764, null, "\u30c1\u30eb\u30c9\u6f14\u7b97\u5b50"),
        REVERSED_TILDE(8765, null, "\u9006\u30c1\u30eb\u30c9"),
        INVERTED_LAZY_S(8766, null, null),
        SIGN_WAVE(8767, null, "\u6b63\u5f26\u6ce2"),
        FULLWIDTH_SPACE(12288, null, "\u5168\u89d2\u30b9\u30da\u30fc\u30b9"),
        IDEOGRAPHIC_COMMA(12289, null, "\u8aad\u70b9"),
        IDEOGRAPHIC_FULL_STOP(12289, null, "\u53e5\u70b9"),
        WAVE_DASH(12316, null, "\u6ce2\u30c0\u30c3\u30b7\u30e5"),
        FULLWIDTH_\u4e2d\u9ed2\u70b9(12539, null, "\u5168\u89d2\u4e2d\u9ed2\u70b9"),
        FULLWIDTH_HYPHEN_MINUS(65293, null, "\u5168\u89d2\u30cf\u30a4\u30d5\u30f3"),
        FULLWIDTH_COLON(65306, null, "\u5168\u89d2\u30b3\u30ed\u30f3"),
        fullwidthFullStop(65294, null, "\u5168\u89d2\u30d4\u30ea\u30aa\u30c9"),
        FULLWIDTH_SOLIDUS(65295, null, "\u5168\u89d2\u659c\u7dda"),
        FULLWIDTH_TILDE(65374, null, "\u5168\u89d2\u30c1\u30eb\u30c9");

        public final char char_;
        public final Byte asciiCode;
        public final String note;
        public final String string;

        private Unicode(int codePoint, Byte asciiCode, String note) {
            this.char_ = (char)codePoint;
            this.asciiCode = asciiCode;
            this.note = note;
            this.string = String.valueOf(this.char_);
        }

        public static Unicode getByChar(char aChar) {
            Unicode[] unicodeArray = Unicode.values();
            int n = unicodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unicode unicode = unicodeArray[n2];
                if (unicode.char_ == aChar) {
                    return unicode;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return this.string;
        }
    }
}

