/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.fst;

import com.atilika.kuromoji.fst.Arc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class State {
    List<Arc> arcs;
    private boolean isFinal = false;
    boolean visited;
    private int targetJumpAddress = -1;

    public State() {
        this.arcs = new ArrayList<Arc>();
    }

    public State(State source) {
        this.arcs = source.arcs;
        this.isFinal = source.isFinal;
    }

    public int getTargetJumpAddress() {
        return this.targetJumpAddress;
    }

    public void setTargetJumpAddress(int targetJumpAddress) {
        this.targetJumpAddress = targetJumpAddress;
    }

    public Arc setArc(char transition, int output, State toState) {
        Arc newArc = new Arc(output, toState, transition);
        this.arcs.add(newArc);
        return newArc;
    }

    public void setArc(char transition, State toState) {
        Arc newArc = new Arc(toState);
        newArc.setLabel(transition);
        this.arcs.add(newArc);
    }

    public List<Character> getAllTransitionStrings() {
        ArrayList<Character> retList = new ArrayList<Character>();
        for (Arc arc : this.arcs) {
            retList.add(Character.valueOf(arc.getLabel()));
        }
        Collections.sort(retList);
        return retList;
    }

    public void setFinal() {
        this.isFinal = true;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Arc findArc(char transition) {
        return this.binarySearchArc(transition, 0, this.arcs.size());
    }

    public Arc binarySearchArc(char transition, int beginIndice, int endIndice) {
        if (beginIndice >= endIndice) {
            return null;
        }
        int indice = beginIndice + (endIndice - beginIndice) / 2;
        if (this.arcs.get(indice).getLabel() == transition) {
            return this.arcs.get(indice);
        }
        if (this.arcs.get(indice).getLabel() > transition) {
            return this.binarySearchArc(transition, beginIndice, indice);
        }
        if (this.arcs.get(indice).getLabel() < transition) {
            return this.binarySearchArc(transition, indice + 1, endIndice);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        if (this.isFinal != state.isFinal) {
            return false;
        }
        return !(this.arcs != null ? !this.arcs.equals(state.arcs) : state.arcs != null);
    }

    public int hashCode() {
        int result = this.arcs != null ? this.arcs.hashCode() : 0;
        result = 31 * result + (this.isFinal ? 1 : 0);
        return result;
    }
}

