/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.PrimeNumberSequenceGenerator;

public class SymbolHash {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected int fTableSize;
    protected Entry[] fBuckets;
    protected int fNum = 0;
    protected int[] fHashMultipliers;

    public SymbolHash() {
        this(101);
    }

    public SymbolHash(int size) {
        this.fTableSize = size;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public void put(Object key, Object value) {
        int collisionCount = 0;
        int hash = this.hash(key);
        int bucket = hash % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            if (key.equals(entry.key)) {
                entry.value = value;
                return;
            }
            ++collisionCount;
            entry = entry.next;
        }
        if (this.fNum >= this.fTableSize) {
            this.rehash();
            bucket = hash % this.fTableSize;
        } else if (collisionCount >= 40 && key instanceof String) {
            this.rebalance();
            bucket = this.hash(key) % this.fTableSize;
        }
        this.fBuckets[bucket] = entry = new Entry(key, value, this.fBuckets[bucket]);
        ++this.fNum;
    }

    public Object get(Object key) {
        int bucket = this.hash(key) % this.fTableSize;
        Entry entry = this.search(key, bucket);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public int getLength() {
        return this.fNum;
    }

    public int getValues(Object[] elements, int from) {
        int i = 0;
        int j = 0;
        while (i < this.fTableSize && j < this.fNum) {
            Entry entry = this.fBuckets[i];
            while (entry != null) {
                elements[from + j] = entry.value;
                ++j;
                entry = entry.next;
            }
            ++i;
        }
        return this.fNum;
    }

    public Object[] getEntries() {
        Object[] entries = new Object[this.fNum << 1];
        int i = 0;
        int j = 0;
        while (i < this.fTableSize && j < this.fNum << 1) {
            Entry entry = this.fBuckets[i];
            while (entry != null) {
                entries[j] = entry.key;
                entries[++j] = entry.value;
                ++j;
                entry = entry.next;
            }
            ++i;
        }
        return entries;
    }

    public SymbolHash makeClone() {
        SymbolHash newTable = new SymbolHash(this.fTableSize);
        newTable.fNum = this.fNum;
        newTable.fHashMultipliers = this.fHashMultipliers != null ? (int[])this.fHashMultipliers.clone() : null;
        int i = 0;
        while (i < this.fTableSize) {
            if (this.fBuckets[i] != null) {
                newTable.fBuckets[i] = this.fBuckets[i].makeClone();
            }
            ++i;
        }
        return newTable;
    }

    public void clear() {
        int i = 0;
        while (i < this.fTableSize) {
            this.fBuckets[i] = null;
            ++i;
        }
        this.fNum = 0;
        this.fHashMultipliers = null;
    }

    protected Entry search(Object key, int bucket) {
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            if (key.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected int hash(Object key) {
        if (this.fHashMultipliers == null || !(key instanceof String)) {
            return key.hashCode() & Integer.MAX_VALUE;
        }
        return this.hash0((String)key);
    }

    private int hash0(String symbol) {
        int code = 0;
        int length = symbol.length();
        int[] multipliers = this.fHashMultipliers;
        int i = 0;
        while (i < length) {
            code = code * multipliers[i & 0x1F] + symbol.charAt(i);
            ++i;
        }
        return code & Integer.MAX_VALUE;
    }

    protected void rehash() {
        this.rehashCommon((this.fBuckets.length << 1) + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int newCapacity) {
        int oldCapacity = this.fBuckets.length;
        Entry[] oldTable = this.fBuckets;
        Entry[] newTable = new Entry[newCapacity];
        this.fBuckets = newTable;
        this.fTableSize = this.fBuckets.length;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    protected static final class Entry {
        public Object key;
        public Object value;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        public Entry(Object key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Entry makeClone() {
            Entry entry = new Entry();
            entry.key = this.key;
            entry.value = this.value;
            if (this.next != null) {
                entry.next = this.next.makeClone();
            }
            return entry;
        }
    }
}

