/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;

public class SSHSession
extends SSHBase {
    private long maxwait = 0L;
    private final Vector localTunnels = new Vector();
    private final Set localPortsUsed = new TreeSet();
    private final Vector remoteTunnels = new Vector();
    private final Set remotePortsUsed = new TreeSet();
    private NestedSequential nestedSequential = null;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";
    private final Vector nestedTasks = new Vector();

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setLocaltunnels(String tunnels) {
        String[] specs = tunnels.split(", ");
        int i = 0;
        while (i < specs.length) {
            if (specs[i].length() > 0) {
                String[] spec = specs[i].split(":", 3);
                int lport = Integer.parseInt(spec[0]);
                String rhost = spec[1];
                int rport = Integer.parseInt(spec[2]);
                LocalTunnel tunnel = this.createLocalTunnel();
                tunnel.setLPort(lport);
                tunnel.setRHost(rhost);
                tunnel.setRPort(rport);
            }
            ++i;
        }
    }

    public void setRemotetunnels(String tunnels) {
        String[] specs = tunnels.split(", ");
        int i = 0;
        while (i < specs.length) {
            if (specs[i].length() > 0) {
                String[] spec = specs[i].split(":", 3);
                int rport = Integer.parseInt(spec[0]);
                String lhost = spec[1];
                int lport = Integer.parseInt(spec[2]);
                RemoteTunnel tunnel = this.createRemoteTunnel();
                tunnel.setRPort(rport);
                tunnel.setLHost(lhost);
                tunnel.setLPort(lport);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute() throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public LocalTunnel createLocalTunnel() {
        LocalTunnel tunnel = new LocalTunnel();
        this.localTunnels.add(tunnel);
        return tunnel;
    }

    public RemoteTunnel createRemoteTunnel() {
        RemoteTunnel tunnel = new RemoteTunnel();
        this.remoteTunnels.add(tunnel);
        return tunnel;
    }

    public NestedSequential createSequential() {
        if (this.nestedSequential != null) {
            throw new BuildException("Only one sequential allowed");
        }
        this.nestedSequential = new NestedSequential();
        return this.nestedSequential;
    }

    public class LocalTunnel {
        int lport = 0;
        String rhost = null;
        int rport = 0;

        public void setLPort(int lport) {
            Integer portKey = new Integer(lport);
            if (SSHSession.this.localPortsUsed.contains(portKey)) {
                throw new BuildException("Multiple local tunnels defined to use same local port " + lport);
            }
            SSHSession.this.localPortsUsed.add(portKey);
            this.lport = lport;
        }

        public void setRHost(String rhost) {
            this.rhost = rhost;
        }

        public void setRPort(int rport) {
            this.rport = rport;
        }

        public int getLPort() {
            if (this.lport == 0) {
                throw new BuildException("lport is required for LocalTunnel.");
            }
            return this.lport;
        }

        public String getRHost() {
            if (this.rhost == null) {
                throw new BuildException("rhost is required for LocalTunnel.");
            }
            return this.rhost;
        }

        public int getRPort() {
            if (this.rport == 0) {
                throw new BuildException("rport is required for LocalTunnel.");
            }
            return this.rport;
        }
    }

    public static class NestedSequential
    implements TaskContainer {
        private final List<Task> nested = new ArrayList<Task>();

        @Override
        public void addTask(Task task) {
            this.nested.add(task);
        }

        public List<Task> getNested() {
            return this.nested;
        }
    }

    public class RemoteTunnel {
        int lport = 0;
        String lhost = null;
        int rport = 0;

        public void setLPort(int lport) {
            this.lport = lport;
        }

        public void setLHost(String lhost) {
            this.lhost = lhost;
        }

        public void setRPort(int rport) {
            Integer portKey = new Integer(rport);
            if (SSHSession.this.remotePortsUsed.contains(portKey)) {
                throw new BuildException("Multiple remote tunnels defined to use same remote port " + rport);
            }
            SSHSession.this.remotePortsUsed.add(portKey);
            this.rport = rport;
        }

        public int getLPort() {
            if (this.lport == 0) {
                throw new BuildException("lport is required for RemoteTunnel.");
            }
            return this.lport;
        }

        public String getLHost() {
            if (this.lhost == null) {
                throw new BuildException("lhost is required for RemoteTunnel.");
            }
            return this.lhost;
        }

        public int getRPort() {
            if (this.rport == 0) {
                throw new BuildException("rport is required for RemoteTunnel.");
            }
            return this.rport;
        }
    }
}

