/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.i18n;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class Translate
extends MatchingTask {
    private static final int BUNDLE_SPECIFIED_LANGUAGE_COUNTRY_VARIANT = 0;
    private static final int BUNDLE_SPECIFIED_LANGUAGE_COUNTRY = 1;
    private static final int BUNDLE_SPECIFIED_LANGUAGE = 2;
    private static final int BUNDLE_NOMATCH = 3;
    private static final int BUNDLE_DEFAULT_LANGUAGE_COUNTRY_VARIANT = 4;
    private static final int BUNDLE_DEFAULT_LANGUAGE_COUNTRY = 5;
    private static final int BUNDLE_DEFAULT_LANGUAGE = 6;
    private static final int BUNDLE_MAX_ALTERNATIVES = 7;
    private String bundle;
    private String bundleLanguage;
    private String bundleCountry;
    private String bundleVariant;
    private File toDir;
    private String srcEncoding;
    private String destEncoding;
    private String bundleEncoding;
    private String startToken;
    private String endToken;
    private boolean forceOverwrite;
    private Vector filesets = new Vector();
    private Hashtable resourceMap = new Hashtable();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private long[] bundleLastModified = new long[7];
    private long srcLastModified;
    private long destLastModified;
    private boolean loaded = false;

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setBundleLanguage(String bundleLanguage) {
        this.bundleLanguage = bundleLanguage;
    }

    public void setBundleCountry(String bundleCountry) {
        this.bundleCountry = bundleCountry;
    }

    public void setBundleVariant(String bundleVariant) {
        this.bundleVariant = bundleVariant;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public void setSrcEncoding(String srcEncoding) {
        this.srcEncoding = srcEncoding;
    }

    public void setDestEncoding(String destEncoding) {
        this.destEncoding = destEncoding;
    }

    public void setBundleEncoding(String bundleEncoding) {
        this.bundleEncoding = bundleEncoding;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    @Override
    public void execute() throws BuildException {
        Locale l;
        if (this.bundle == null) {
            throw new BuildException("The bundle attribute must be set.", this.getLocation());
        }
        if (this.startToken == null) {
            throw new BuildException("The starttoken attribute must be set.", this.getLocation());
        }
        if (this.endToken == null) {
            throw new BuildException("The endtoken attribute must be set.", this.getLocation());
        }
        if (this.bundleLanguage == null) {
            l = Locale.getDefault();
            this.bundleLanguage = l.getLanguage();
        }
        if (this.bundleCountry == null) {
            this.bundleCountry = Locale.getDefault().getCountry();
        }
        if (this.bundleVariant == null) {
            l = new Locale(this.bundleLanguage, this.bundleCountry);
            this.bundleVariant = l.getVariant();
        }
        if (this.toDir == null) {
            throw new BuildException("The todir attribute must be set.", this.getLocation());
        }
        if (!this.toDir.exists()) {
            this.toDir.mkdirs();
        } else if (this.toDir.isFile()) {
            throw new BuildException(this.toDir + " is not a directory");
        }
        if (this.srcEncoding == null) {
            this.srcEncoding = System.getProperty("file.encoding");
        }
        if (this.destEncoding == null) {
            this.destEncoding = this.srcEncoding;
        }
        if (this.bundleEncoding == null) {
            this.bundleEncoding = this.srcEncoding;
        }
        this.loadResourceMaps();
        this.translate();
    }

    private void loadResourceMaps() throws BuildException {
        Locale locale = new Locale(this.bundleLanguage, this.bundleCountry, this.bundleVariant);
        String language = locale.getLanguage().length() > 0 ? "_" + locale.getLanguage() : "";
        String country = locale.getCountry().length() > 0 ? "_" + locale.getCountry() : "";
        String variant = locale.getVariant().length() > 0 ? "_" + locale.getVariant() : "";
        String bundleFile = String.valueOf(this.bundle) + language + country + variant;
        this.processBundle(bundleFile, 0, false);
        bundleFile = String.valueOf(this.bundle) + language + country;
        this.processBundle(bundleFile, 1, false);
        bundleFile = String.valueOf(this.bundle) + language;
        this.processBundle(bundleFile, 2, false);
        bundleFile = this.bundle;
        this.processBundle(bundleFile, 3, false);
        locale = Locale.getDefault();
        language = locale.getLanguage().length() > 0 ? "_" + locale.getLanguage() : "";
        country = locale.getCountry().length() > 0 ? "_" + locale.getCountry() : "";
        variant = locale.getVariant().length() > 0 ? "_" + locale.getVariant() : "";
        this.bundleEncoding = System.getProperty("file.encoding");
        bundleFile = String.valueOf(this.bundle) + language + country + variant;
        this.processBundle(bundleFile, 4, false);
        bundleFile = String.valueOf(this.bundle) + language + country;
        this.processBundle(bundleFile, 5, false);
        bundleFile = String.valueOf(this.bundle) + language;
        this.processBundle(bundleFile, 6, true);
    }

    private void processBundle(String bundleFile, int i, boolean checkLoaded) throws BuildException {
        block2: {
            File propsFile = this.getProject().resolveFile(String.valueOf(bundleFile) + ".properties");
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(propsFile);
                this.loaded = true;
                this.bundleLastModified[i] = propsFile.lastModified();
                this.log("Using " + propsFile, 4);
                this.loadResourceMap(ins);
            }
            catch (IOException ioe) {
                this.log(propsFile + " not found.", 4);
                if (this.loaded || !checkLoaded) break block2;
                throw new BuildException(ioe.getMessage(), this.getLocation());
            }
        }
    }

    private void loadResourceMap(FileInputStream ins) throws BuildException {
        try {
            BufferedReader in = null;
            InputStreamReader isr = new InputStreamReader((InputStream)ins, this.bundleEncoding);
            in = new BufferedReader(isr);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 1 || '#' == line.charAt(0) || '!' == line.charAt(0)) continue;
                int sepIndex = line.indexOf(61);
                if (-1 == sepIndex) {
                    sepIndex = line.indexOf(58);
                }
                if (-1 == sepIndex) {
                    int k = 0;
                    while (k < line.length()) {
                        if (Character.isSpaceChar(line.charAt(k))) {
                            sepIndex = k;
                            break;
                        }
                        ++k;
                    }
                }
                if (-1 == sepIndex) continue;
                String key = line.substring(0, sepIndex).trim();
                String value = line.substring(sepIndex + 1).trim();
                while (value.endsWith("\\")) {
                    value = value.substring(0, value.length() - 1);
                    line = in.readLine();
                    if (line == null) break;
                    value = String.valueOf(value) + line.trim();
                }
                if (key.length() <= 0 || this.resourceMap.get(key) != null) continue;
                this.resourceMap.put(key, value);
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), this.getLocation());
        }
    }

    private void translate() throws BuildException {
        int filesProcessed = 0;
        int size = this.filesets.size();
        int i = 0;
        while (i < size) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            int j = 0;
            while (j < srcFiles.length) {
                try {
                    boolean needsWork;
                    File dest = FILE_UTILS.resolveFile(this.toDir, srcFiles[j]);
                    try {
                        File destDir = new File(dest.getParent());
                        if (!destDir.exists()) {
                            destDir.mkdirs();
                        }
                    }
                    catch (Exception e) {
                        this.log("Exception occurred while trying to check/create  parent directory.  " + e.getMessage(), 4);
                    }
                    this.destLastModified = dest.lastModified();
                    File src = FILE_UTILS.resolveFile(ds.getBasedir(), srcFiles[j]);
                    this.srcLastModified = src.lastModified();
                    boolean bl = needsWork = this.forceOverwrite || this.destLastModified < this.srcLastModified;
                    if (!needsWork) {
                        int icounter = 0;
                        while (icounter < 7) {
                            boolean bl2 = needsWork = this.destLastModified < this.bundleLastModified[icounter];
                            if (needsWork) break;
                            ++icounter;
                        }
                    }
                    if (needsWork) {
                        this.log("Processing " + srcFiles[j], 4);
                        this.translateOneFile(src, dest);
                        ++filesProcessed;
                    } else {
                        this.log("Skipping " + srcFiles[j] + " as destination file is up to date", 3);
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException(ioe.getMessage(), this.getLocation());
                }
                ++j;
            }
            ++i;
        }
        this.log("Translation performed on " + filesProcessed + " file(s).", 4);
    }

    private void translateOneFile(File src, File dest) throws IOException {
        BufferedWriter out = null;
        BufferedReader in = null;
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.destEncoding));
            FileInputStream fis = new FileInputStream(src);
            in = new BufferedReader(new InputStreamReader((InputStream)fis, this.srcEncoding));
            LineTokenizer lineTokenizer = new LineTokenizer();
            lineTokenizer.setIncludeDelims(true);
            String line = lineTokenizer.getToken(in);
            while (line != null) {
                int startIndex = line.indexOf(this.startToken);
                while (startIndex >= 0 && startIndex + this.startToken.length() <= line.length()) {
                    String replace = null;
                    int endIndex = line.indexOf(this.endToken, startIndex + this.startToken.length());
                    if (endIndex < 0) {
                        ++startIndex;
                    } else {
                        String token = line.substring(startIndex + this.startToken.length(), endIndex);
                        boolean validToken = true;
                        int k = 0;
                        while (k < token.length() && validToken) {
                            char c = token.charAt(k);
                            if (c == ':' || c == '=' || Character.isSpaceChar(c)) {
                                validToken = false;
                            }
                            ++k;
                        }
                        if (!validToken) {
                            ++startIndex;
                        } else {
                            if (this.resourceMap.containsKey(token)) {
                                replace = (String)this.resourceMap.get(token);
                            } else {
                                this.log("Replacement string missing for: " + token, 3);
                                replace = String.valueOf(this.startToken) + token + this.endToken;
                            }
                            line = String.valueOf(line.substring(0, startIndex)) + replace + line.substring(endIndex + this.endToken.length());
                            startIndex += replace.length();
                        }
                    }
                    startIndex = line.indexOf(this.startToken, startIndex);
                }
                out.write(line);
                line = lineTokenizer.getToken(in);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }
}

