/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.dao;

import ext.base.core.BcInteger;
import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.scf5.model.ScfAttributeElement;
import ext.scf5.model.ZScfIntProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScfAbstractAttributeElementDAO
extends OrmAbstractDAO {
    protected String column_data_id = "data_id";
    protected String column_item_id = "item_id";
    protected String column_index = "index_";
    protected String column_value = "value_";

    public ScfAbstractAttributeElementDAO() {
        super(new Object[0]);
    }

    protected List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add(this.column_data_id);
        this.updateColumnList.add(this.column_item_id);
        this.updateColumnList.add(this.column_index);
        this.updateColumnList.add(this.column_value);
        return this.updateColumnList;
    }

    protected List<Object> toValueList(ScfAttributeElement attributeElement) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.add(attributeElement.parentId);
        valueList.add(attributeElement.itemId);
        valueList.add(attributeElement.index);
        valueList.add(attributeElement.value);
        return valueList;
    }

    protected String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getPersistenceProxy().createCommonSelectPhrase(ScfAttributeElement.class, tableAlias));
        int i = 0;
        while (i < this.getUpdateColumnList().size()) {
            sb.append(String.valueOf(asTable2) + this.getUpdateColumnList().get(i));
            ++i;
        }
        return sb.toString();
    }

    public void putAttributeElement(DtsSession dtsSession, ScfAttributeElement attributeElement) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(attributeElement);
        this.getPersistenceProxy().putEntity(dtsSession, this.tableName, columnList, valueList, attributeElement);
    }

    public void putAttributeElement(DtsSession dtsSession, int parentId, int itemId, int index, CharSequence value) throws Exception {
        ScfAttributeElement attributeElement = new ScfAttributeElement();
        attributeElement.parentId = parentId;
        attributeElement.itemId = itemId;
        attributeElement.index = index;
        if (!BcStringUtil.isEmpty(value)) {
            attributeElement.value = value.toString();
        }
        this.putAttributeElement(dtsSession, attributeElement);
    }

    public void putAttributeElement(DtsSession dtsSession, int parentId, int itemId, CharSequence value) throws Exception {
        this.putAttributeElement(dtsSession, parentId, itemId, 1, value);
    }

    public void putAttributeElement(DtsSession dtsSession, int parentId, ZScfIntProperties intProps) throws Exception {
        Object[] keys = intProps.keySet().toArray();
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Integer itemId = (Integer)keys[i];
            String value = intProps.get(itemId);
            this.putAttributeElement(dtsSession, parentId, itemId, value);
            ++i;
        }
    }

    public int deleteAttributeElement(DtsSession dtsSession, int attributeElementId) throws Exception {
        int deletedCount = this.getPersistenceProxy().logicalDeleteByDataId(dtsSession, this.tableName, attributeElementId);
        return deletedCount;
    }

    public int deleteAttributeByOwner(DtsSession dtsSession, int parentId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = " DELETE FROM " + this.tableName + " WHERE " + this.column_data_id + "=" + parentId;
        int deletedCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            deletedCount = stmt.executeUpdate(query);
        }
        return deletedCount;
    }

    protected void getAttributeElement(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, ScfAttributeElement attributeElement) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, attributeElement);
        attributeElement.parentId = rs.getInt(columnIndex);
        attributeElement.itemId = rs.getInt(columnIndex);
        attributeElement.index = rs.getInt(columnIndex);
        attributeElement.value = rs.getString(columnIndex);
    }

    protected ScfAttributeElement getAttributeElement(DtsSession dtsSession, String query) throws Exception {
        ScfAttributeElement attributeElement = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                attributeElement = new ScfAttributeElement();
                this.getAttributeElement(dtsSession, rs, columnIndex, attributeElement);
            }
            rs.close();
        }
        return attributeElement;
    }

    protected void getAttributeElementList(DtsSession dtsSession, String query, List<ScfAttributeElement> dataList) throws Exception {
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            BcInteger columnIndex = new BcInteger();
            while (rs.next()) {
                columnIndex.value = 0;
                ScfAttributeElement attributeElement = new ScfAttributeElement();
                this.getAttributeElement(dtsSession, rs, columnIndex, attributeElement);
                dataList.add(attributeElement);
            }
            rs.close();
        }
    }

    public ScfAttributeElement getAttributeElement(DtsSession dtsSession, int parentId, int itemId, int index) throws Exception {
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.viewName + " WHERE " + this.column_data_id + "=" + parentId + " AND " + this.column_item_id + "=" + itemId + " AND " + this.column_index + "=" + index;
        return this.getAttributeElement(dtsSession, query);
    }

    public ScfAttributeElement getAttributeElement(DtsSession dtsSession, int parentId, int itemId) throws Exception {
        return this.getAttributeElement(dtsSession, parentId, itemId, 1);
    }

    public List<ScfAttributeElement> getAttributeElementList(DtsSession dtsSession, int parentId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.viewName + " WHERE " + this.column_data_id + sqlContext.toCondition_number("=", parentId);
        ArrayList<ScfAttributeElement> dataList = new ArrayList<ScfAttributeElement>();
        this.getAttributeElementList(dtsSession, query, dataList);
        return dataList;
    }

    public String getValue(DtsSession dtsSession, int parentId, int itemId, int index) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.column_value + " FROM " + this.viewName + " WHERE " + this.column_data_id + "=" + parentId + " AND " + this.column_item_id + "=" + itemId + " AND " + this.column_index + "=" + index;
        String value = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                value = rs.getString(1);
            }
            rs.close();
        }
        return value;
    }

    public String getValue(DtsSession dtsSession, int parentId, int itemId) throws Exception {
        return this.getValue(dtsSession, parentId, itemId, 1);
    }
}

