/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.datasource;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcArgumentUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.scf.datasource.ScfDatasourceConfigParser;
import ext.scf.server.ScfAbstractServerModule;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfDatasourceModule
extends ScfAbstractServerModule {
    public static int schemaVersionOfBoot;

    @Override
    public void setModuleNode(Node domNode) throws Exception {
        String tmpStr = BcXmlUtil.getTextValue(domNode, "schemaVersion");
        schemaVersionOfBoot = BcNumberUtil.parseInt(tmpStr, -1);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setupDatasource();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void end() throws Exception {
        DtsSessionFactoryManegaer.getInstance().close();
    }

    protected void setupDatasource() throws Exception {
        String rFilePath;
        AfbApplication application = AfbApplication.getInstance();
        String vFilePath = BcArgumentUtil.getArgumentValue(application.getMainArguments(), "-datasource");
        File file = null;
        if (BcStringUtil.isEmpty(vFilePath)) {
            rFilePath = application.toReal("${APP}config/datasource.xml");
            file = new File(rFilePath);
            if (!file.exists()) {
                rFilePath = application.toReal("${COMMON}config/datasource.xml");
                file = new File(rFilePath);
            }
        } else {
            rFilePath = application.toReal("${COMMON}config/datasource.xml");
            file = new File(rFilePath);
        }
        if (!file.exists()) {
            BcLogUtil.warning("Not found datasource config.");
            return;
        }
        Document domDoc = BcXmlUtil.createDocument(file);
        if (!domDoc.getFirstChild().getNodeName().equals("datasources")) {
            throw new Exception("Not suported node. '" + domDoc.getFirstChild().getNodeName() + "'");
        }
        ScfDatasourceConfigParser datasourceConfigParser = new ScfDatasourceConfigParser();
        List<DtsSessionFactory> list = datasourceConfigParser.parseDatasourceConfig(domDoc, DtsSessionFactoryManegaer.getInstance());
    }
}

