/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.datasource;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcLangUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.xml.BcXmlUtil;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import java.io.File;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfDatasourceConfigParser
extends BcLoggableObject {
    public static final String TAG_datasource = "datasource";

    public List<DtsSessionFactory> parseDatasourceConfig(Document xmlDoc, DtsSessionFactoryManegaer sessionFactoryManegaer) throws Exception {
        ArrayList<DtsSessionFactory> dtsSessionFactoryList = new ArrayList<DtsSessionFactory>();
        List<Node> nodeList1 = BcXmlUtil.getNodeList((Node)xmlDoc, (short)1);
        int i = 0;
        while (i < nodeList1.size()) {
            Node node1 = nodeList1.get(i);
            if (!node1.getNodeName().equals(TAG_datasource)) {
                throw new Exception("not suported node '" + node1.getNodeName() + "'");
            }
            String name = BcXmlUtil.getAttribute(node1, "name");
            DtsConnectionManager connectionManager = this.setupDatasourceL2(node1, name);
            DtsSessionFactory dtsSessionFactory = new DtsSessionFactory(name, connectionManager);
            dtsSessionFactory.setLogger(connectionManager.getLogger());
            sessionFactoryManegaer.addSessionFactory(dtsSessionFactory);
            dtsSessionFactoryList.add(dtsSessionFactory);
            ++i;
        }
        return dtsSessionFactoryList;
    }

    protected DtsConnectionManager setupDatasourceL2(Node baseNode, String dataSourceName) throws Exception {
        long tmpValue;
        String user;
        BcResult result = new BcResult();
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        String driverFilePath = BcXmlUtil.getTextValue(baseNode, "driverFile");
        File driverFile = null;
        if (!BcStringUtil.isEmpty(driverFilePath) && !(driverFile = new File(driverFilePath = AfbApplication.getInstance().toReal(driverFilePath))).exists()) {
            result.addError(String.format("File not Found. path=" + driverFilePath, new Object[0]));
        }
        String driverClassName = BcXmlUtil.getTextValue(baseNode, "jdbcDriver");
        Driver driver = null;
        driver = driverFile == null ? SqlUtil.createDriver(driverClassName) : SqlUtil.createDriver(driverFile, driverClassName);
        if (driver == null) {
            result.addError(String.format("Driver not Found. className=" + driverClassName, new Object[0]));
        }
        String url = BcXmlUtil.getTextValue(baseNode, "url");
        url = AfbApplication.getInstance().toReal(url);
        if (BcStringUtil.isEmpty(url)) {
            result.addError(String.format("'url' is invalid. value=" + url, new Object[0]));
        }
        if (BcStringUtil.isEmpty(user = BcXmlUtil.getTextValue(baseNode, "user"))) {
            result.addError(String.format("'user' is invalid. value=" + user, new Object[0]));
        }
        String password = BcXmlUtil.getTextValue(baseNode, "password");
        String tmpStr = BcXmlUtil.getTextValue(baseNode, "validationInterval");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            tmpValue = BcNumberUtil.parseLong(tmpStr, -1L);
            connectionManager.setValidationInterval(tmpValue);
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "validationDelay"))) {
            tmpValue = BcNumberUtil.parseLong(tmpStr, -1L);
            connectionManager.setValidationDelay(tmpValue);
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "minIdle"))) {
            connectionManager.setMinIdle(BcNumberUtil.parseInteger(tmpStr, -1));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "maxIdle"))) {
            connectionManager.setMaxIdle(BcNumberUtil.parseInteger(tmpStr, -1));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "maxConnection"))) {
            connectionManager.setMaxConnection(BcNumberUtil.parseInteger(tmpStr, -1));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "maxUsage"))) {
            connectionManager.setMaxUsage(BcNumberUtil.parseInteger(tmpStr, -1));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "queryTimeout"))) {
            int tmpValue2 = (int)(BcNumberUtil.parseLong(tmpStr, -1L) / 1000L);
            connectionManager.setQueryTimeout(Math.max(tmpValue2, 0));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "lendingTimeout"))) {
            connectionManager.setLendingTimeout(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "queryTimeoutForScroll"))) {
            int tmpValue3 = (int)(BcNumberUtil.parseLong(tmpStr, -1L) / 1000L);
            connectionManager.setQueryTimeoutForScroll(Math.max(tmpValue3, 0));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "lendingTimeoutForScroll"))) {
            int tmpValue4 = (int)(BcNumberUtil.parseLong(tmpStr, -1L) / 1000L);
            connectionManager.setLendingTimeoutForScroll(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "longQueryTime"))) {
            connectionManager.setLongQueryTime(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        Properties dtsProps = new Properties();
        if (!BcStringUtil.isEmpty(user)) {
            dtsProps.setProperty(SqlConstants.DataSourceProperty.user.name(), user);
        }
        if (!BcStringUtil.isEmpty(password)) {
            dtsProps.setProperty(SqlConstants.DataSourceProperty.password.name(), password);
        }
        List<Node> nodeList2 = BcXmlUtil.getNodeList(baseNode, "param");
        int i = 0;
        while (i < nodeList2.size()) {
            Node node2 = nodeList2.get(i);
            String name = BcXmlUtil.getAttribute(node2, "name");
            String value = BcXmlUtil.getAttribute(node2, "value");
            dtsProps.put(name, value);
            ++i;
        }
        String logLevelStr = BcXmlUtil.getTextValue(baseNode, BcLogConstants.LogAttribute.logLevel.name());
        BcLogConstants.LogLevel logLevel = BcLogUtil.logLevelDefault;
        if (!BcStringUtil.isEmpty(logLevelStr)) {
            logLevel = BcLangUtil.getEnumByName(BcLogConstants.LogLevel.class, logLevelStr);
        }
        if (logLevel != null) {
            ScfDatasourceConfigParser.setupLogger(connectionManager, AfbApplication.getInstance().getLogDir(), dataSourceName);
        } else {
            result.addError(String.format("'logLevel' is invalid. value=" + logLevelStr, new Object[0]));
        }
        if (result.hasError()) {
            String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            throw new Exception(msg);
        }
        ((DtsConnectionManager)connectionManager).setup(driver, url, dtsProps);
        String validationQuery = BcXmlUtil.getTextValue(baseNode, "validationQuery");
        if (!BcStringUtil.isEmpty(validationQuery)) {
            ((DtsConnectionManager)connectionManager).getSqlContext(null).setValidationQuery(validationQuery);
        }
        return connectionManager;
    }

    public static void setupLogger(DtsConnectionManager connectionManager, File logDir, String dataSourceName) throws Exception {
        String loggerName = "dataSource[" + dataSourceName + "]";
        String fileName = String.valueOf(loggerName) + ".log";
        File logFile = new File(logDir, fileName);
        BcLogger logger = BcLogUtil.createLogger(loggerName, false, BcLogConstants.LogLevel.INFO, true, logFile);
        connectionManager.setLogger(logger);
    }

    public static void setupLogger(DtsSessionFactory dtsSessionFactory, File logDir) throws Exception {
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory.getConnectionManager(), logDir, dtsSessionFactory.getName());
    }
}

