/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.server;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.server.RmiAgentEventHandler;
import ext.lib.rmi.server.RmiServer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContext_H2;
import ext.module.xsys.server.XsysDatasourceUpdater;
import ext.scf.datasource.ScfDatasourceConfigParser;
import ext.scf.server.ScfAbstractServerModule;
import ext.scf.server.ScfServerContainer;
import ext.scf5.dao.ScfSchemaVersionDAO;
import ext.scf5.model.ScfSchemaVersion;
import java.sql.Driver;
import java.util.Properties;

public class XsysServerModule
extends ScfAbstractServerModule
implements RmiAgentEventHandler {
    @Override
    public void init() throws Exception {
        this.setupDatasource();
        this.updateSchema();
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmixServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmixServer.addAgentEventHandler(this);
        }
    }

    protected void setupDatasource() throws Exception {
        String dbPath = AfbApplication.getInstance().toReal("${APP}data/main");
        String driverClassName = "org.h2.Driver";
        String jdbcUrl = SqlContext_H2.cretaeUrlFile(dbPath);
        Properties sqlConnProps = new Properties();
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.user.name(), "xsys_admin");
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.password.name(), "ex4rhk8x");
        Driver driver = SqlUtil.createDriver(driverClassName);
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(driver, jdbcUrl, sqlConnProps);
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory("main", connectionManager);
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory, AfbApplication.getInstance().getLogDir());
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
    }

    protected void updateSchema() throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        DtsSession dtsSession = dtsSessionFactory.createSession(this);
        try {
            try {
                SqlContext sqlContext = dtsSession.getSqlContext();
                ScfSchemaVersion schemaVersion = null;
                if (sqlContext.existTable(dtsSession.getConnection(), ScfSchemaVersionDAO.getInstance().getTableName())) {
                    schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSession);
                }
                if (schemaVersion == null) {
                    schemaVersion = new ScfSchemaVersion();
                    schemaVersion.versionId = 0;
                }
                if (schemaVersion.versionId > 6) {
                    String msg = "Not suport. schemaVersion=" + schemaVersion.versionId;
                    throw new Exception(msg);
                }
                while (schemaVersion.versionId < 6) {
                    ++schemaVersion.versionId;
                    schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
                    XsysDatasourceUpdater datasourceUpdater = new XsysDatasourceUpdater();
                    datasourceUpdater.update(dtsSession, schemaVersion.versionId, true);
                    schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
                    ScfSchemaVersionDAO.getInstance().putEntity(dtsSession, schemaVersion);
                    dtsSession.commit();
                }
            }
            catch (Exception ex) {
                dtsSession.rollback();
                throw ex;
            }
        }
        finally {
            dtsSession.desturuct();
        }
    }

    @Override
    public void agentAdded(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void agentRemoved(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        BcLogUtil.error(throwable);
    }
}

