/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xsod.model.XsodCategory;
import java.util.List;

public class XsodCategoryDAO
extends OrmAbstractDAO<XsodCategory> {
    public static final int MODE_default = 1;

    private XsodCategoryDAO() {
        super(new XsodCategory[0]);
        this.setTableName("xsod_category");
    }

    public static XsodCategoryDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, String code, int setId) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (!BcStringUtil.isEmpty(code)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "code" + sqlContext.toCondition_string("=", code));
            selectQuery.addWhereElement(whereElement);
        }
        if (setId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "set_id = " + setId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "parent_code");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "priority");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public List<XsodCategory> getList(DtsSession dtsSession, int setId, String code) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "mdctg";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, code, setId);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public XsodCategory getByCode(DtsSession dtsSession, String code) throws Exception {
        if (BcStringUtil.isEmpty(code)) {
            return null;
        }
        int setId = -1;
        List<XsodCategory> entityList = this.getList(dtsSession, setId, code);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XsodCategoryDAO(XsodCategoryDAO xsodCategoryDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodCategoryDAO instance = new XsodCategoryDAO(null);

        private SingletonHolder() {
        }
    }
}

