/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.common;

import ext.appfw.common.AfbApplication;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.lib.awt.AwtImageUtil;
import ext.lib.http.client.HtclContentLoader;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xsod.common.EtcFileCash;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class EtcImageCash {
    private EtcFileCash fileCash;
    private Map<Comparable, BufferedImage> imageMap1 = new HashMap<Comparable, BufferedImage>();
    private Map<Comparable, BufferedImage> imageMap2 = new HashMap<Comparable, BufferedImage>();
    private Comparable preKey;
    private int maxElement = 10;
    HtclContentLoader contentLoader = new HtclContentLoader();

    public EtcImageCash() {
        this.setFileCash(new EtcFileCash());
    }

    public EtcFileCash getFileCash() {
        return this.fileCash;
    }

    public void setFileCash(EtcFileCash fileCash) {
        this.fileCash = fileCash;
    }

    public BufferedImage getImage(Comparable key, File file) throws Exception {
        BcLogUtil.warning("getImage#1:file=" + file.getPath());
        return AwtImageUtil.loadImageByImageIO(file);
    }

    public BufferedImage getThumbnail(Comparable key, File file) throws Exception {
        BufferedImage bufferedImage = this.imageMap2.get(key);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        String pathStr = AfbApplication.getInstance().toReal("${APP}temp/thumbnail");
        File thumbnailDir = new File(pathStr);
        File thumbnailFile = new File(thumbnailDir, file.getName());
        if (thumbnailFile.exists()) {
            FileInputStream is = new FileInputStream(thumbnailFile);
            bufferedImage = AwtImageUtil.loadImage((InputStream)is, BcFileUtil.getExtention(file));
        } else {
            bufferedImage = this.getImage(key, file);
            if (bufferedImage == null) {
                BcLogUtil.warning("File not found. path=" + file.getPath());
                return bufferedImage;
            }
            bufferedImage = this.toThumbnail(bufferedImage);
            BcFileUtil.makeParent(thumbnailFile);
            FileOutputStream os = new FileOutputStream(thumbnailFile);
            ImageIO.write((RenderedImage)bufferedImage, BcFileUtil.getExtention(thumbnailFile), os);
        }
        this.imageMap2.put(key, bufferedImage);
        return bufferedImage;
    }

    protected BufferedImage toThumbnail(Image srcImage) throws Exception {
        BufferedImage bufferedImage = AwtImageUtil.extractImage(srcImage, 400.0, 200.0);
        return bufferedImage;
    }

    public BufferedImage getImage(Comparable key, URI uri) throws Exception {
        ByteArrayOutputStream baos = this.contentLoader.getContent(uri.toURL());
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        XfilUriEntity uriEntity = XfilUtil.toUriEntity(uri, true);
        return AwtImageUtil.loadImage((InputStream)bais, uriEntity.extention);
    }

    public BufferedImage getThumbnail(Comparable key, URI uri) throws Exception {
        BufferedImage bufferedImage = this.imageMap2.get(key);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        bufferedImage = this.getImage(key, uri);
        bufferedImage = this.toThumbnail(bufferedImage);
        return bufferedImage;
    }
}

