/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.server;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcInputValidator;
import ext.lib.datasource.DtsSession;
import ext.lib.json.JacksonUtil;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVideoCaptureParameter;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class XfilVisitFile
extends BcLoggableObject {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileVisitResult visitFile(Path path, DtsSession dtsSessionWk, XfilUriEntityDAO uriEntityDao, boolean overwrirte, List<String> fileExtentionList, long indexGroupId, XfilCrawl crawl, XfilVideoCaptureParameter videoCaptureParameter, String note, List<String> exclusionPathList) throws Exception {
        this.getLogger().info("FileVisit:path=" + path);
        if (Files.isHidden(path)) {
            return FileVisitResult.CONTINUE;
        }
        if (!BcCollectionUtil.isEmpty(exclusionPathList)) {
            int index = exclusionPathList.indexOf(path.toString());
            this.getLogger().info("index=" + index);
            if (exclusionPathList.contains(path.toString())) {
                this.getLogger().info("Exclusion:path=" + path);
                return FileVisitResult.CONTINUE;
            }
        }
        XfilUriEntity uriEntity1 = XfilUtil.toUriEntity(path, true);
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.getLogger().info("Directory:" + path.toFile().getName());
            if (!path.toFile().getName().equalsIgnoreCase("VIDEO_TS")) return FileVisitResult.CONTINUE;
            uriEntity1 = XfilUtil.toUriEntity(path.getParent(), true);
            uriEntity1.childCount = path.toFile().listFiles().length;
            fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        } else {
            uriEntity1.childCount = -1;
            if (!XfilUtil.isAllowedFileExtention(fileExtentionList, uriEntity1.extention)) {
                String msg = String.format("Extention '%s' is not allowd.", uriEntity1.extention);
                this.getLogger().warning(msg);
                return FileVisitResult.CONTINUE;
            }
        }
        List uriEntityList = uriEntityDao.getListByPath(dtsSessionWk, indexGroupId, uriEntity1.directory, uriEntity1.name, false);
        if (!BcCollectionUtil.isEmpty(uriEntityList)) {
            XfilUriEntity uriEntity2 = (XfilUriEntity)BcCollectionUtil.getFirst(uriEntityList);
            String msg = BcInputValidator.getInstance().$_exists(BcStringUtil.singleQuotation(uriEntity1.name));
            this.getLogger().info(msg);
            if (!overwrirte) {
                return FileVisitResult.CONTINUE;
            }
            uriEntity1.id = uriEntity2.id;
            uriEntity1.addTimestamp = uriEntity2.addTimestamp;
            uriEntity1.updateTimestamp = uriEntity2.updateTimestamp;
        }
        uriEntity1.indexGroupId = indexGroupId;
        uriEntity1.crawlId = crawl.id;
        if (videoCaptureParameter != null) {
            uriEntity1.videoCaptureParameter = JacksonUtil.getObjectMapper().writeValueAsString((Object)videoCaptureParameter);
        }
        uriEntity1.text01 = note;
        uriEntityDao.putEntity(dtsSessionWk, uriEntity1);
        this.getLogger().info("ADD:id=" + uriEntity1.id + " path=" + path.toString());
        return fileVisitResult;
    }
}

