/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.media.AudioSpectrumListener;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.stage.Stage;
import javafx.util.StringConverter;

public class AudioBarChartApp
extends Application {
    private XYChart.Data<String, Number>[] series1Data;
    private AudioSpectrumListener audioSpectrumListener = (timestamp, duration, magnitudes, phases) -> {
        int i = 0;
        while (i < this.series1Data.length) {
            this.series1Data[i].setYValue((Object)Float.valueOf(magnitudes[i] + 60.0f));
            ++i;
        }
    };
    private static final String AUDIO_URI = System.getProperty("demo.audio.url", "http://download.oracle.com/otndocs/products/javafx/oow2010-2.flv");
    private MediaPlayer audioMediaPlayer;
    private static final boolean PLAY_AUDIO = Boolean.parseBoolean(System.getProperty("demo.play.audio", "true"));

    public void play() {
        this.startAudio();
    }

    public void stop() {
        this.stopAudio();
    }

    public Parent createContent() {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis(0.0, 50.0, 10.0);
        BarChart bc = new BarChart((Axis)xAxis, (Axis)yAxis);
        bc.getStylesheets().add((Object)AudioBarChartApp.class.getResource("AudioBarChart.css").toExternalForm());
        bc.setLegendVisible(false);
        bc.setAnimated(false);
        bc.setBarGap(0.0);
        bc.setCategoryGap(1.0);
        bc.setVerticalGridLinesVisible(false);
        bc.setTitle("Live Audio Spectrum Data");
        xAxis.setLabel("Frequency Bands");
        yAxis.setLabel("Magnitudes");
        yAxis.setTickLabelFormatter((StringConverter)new NumberAxis.DefaultFormatter(yAxis, null, "dB"));
        XYChart.Series series1 = new XYChart.Series();
        series1.setName("Data Series 1");
        this.series1Data = new XYChart.Data[128];
        String[] categories = new String[128];
        int i = 0;
        while (i < this.series1Data.length) {
            categories[i] = Integer.toString(i + 1);
            this.series1Data[i] = new XYChart.Data((Object)categories[i], (Object)50);
            series1.getData().add(this.series1Data[i]);
            ++i;
        }
        bc.getData().add((Object)series1);
        return bc;
    }

    private void startAudio() {
        if (PLAY_AUDIO) {
            this.getAudioMediaPlayer().setAudioSpectrumListener(this.audioSpectrumListener);
            this.getAudioMediaPlayer().play();
        }
    }

    private void stopAudio() {
        if (this.getAudioMediaPlayer().getAudioSpectrumListener() == this.audioSpectrumListener) {
            this.getAudioMediaPlayer().pause();
        }
    }

    private MediaPlayer getAudioMediaPlayer() {
        if (this.audioMediaPlayer == null) {
            Media audioMedia = new Media(AUDIO_URI);
            this.audioMediaPlayer = new MediaPlayer(audioMedia);
            this.audioMediaPlayer.setCycleCount(-1);
        }
        return this.audioMediaPlayer;
    }

    public void start(Stage primaryStage) throws Exception {
        primaryStage.setScene(new Scene(this.createContent()));
        primaryStage.show();
        this.play();
    }

    public static void main(String[] args) {
        AudioBarChartApp.launch((String[])args);
    }
}

