/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.rmo;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.libx.etc.util.EtcEnumStrUtil;
import ext.libx.etc.util.EtcWordUtil;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.dao.XdtsCustomSqlDAO;
import ext.module.xdts.model.XdtsCustomSql;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class XdtsCustomSqlRMO
extends RmiAbstractRMO {
    String namePrefix = "SQL-";

    public void putEntity(RmiRmoArgument rmoArg) throws Exception {
        XdtsCustomSql customSql = (XdtsCustomSql)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        customSql.name = BcStringUtil.trim(customSql.name);
        customSql.group = XdtsUtil.reformPath(customSql.group);
        XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        if (BcStringUtil.isEmpty(customSql.name)) {
            customSql.name = this.createName(dtsSession, customSql.profileId, customSql.getDataId(), null, this.namePrefix);
            XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        }
        rmoArg.getRespons().addData(customSql);
    }

    public void getEntity(RmiRmoArgument rmoArg) throws Exception {
        int entityId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(customSql);
    }

    public void deleteEntity(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql sustomSql = new XdtsCustomSql();
        int cnt = 0;
        for (Integer entityId : entityIdCollection) {
            sustomSql.setDataId(entityId);
            cnt += XdtsCustomSqlDAO.getInstance().deleteEntity(dtsSession, sustomSql);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getCustomSqlList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List customSqlList = XdtsCustomSqlDAO.getInstance().getList(dtsSession, profileId);
        rmoArg.getRespons().addData(customSqlList);
    }

    public void copyCustomSql(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection customSqlIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsCustomSql> customSqlList = new ArrayList<XdtsCustomSql>();
        Iterator iterator = customSqlIdCollection.iterator();
        while (iterator.hasNext()) {
            int customSqlId = (Integer)iterator.next();
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, customSqlId);
            customSql.name = this.createName(dtsSession, customSql.profileId, customSql.getDataId(), customSql.name, this.namePrefix);
            customSql.setObjectId(-1L);
            customSql.setDataId(-1);
            customSql.profileId = profileId;
            customSql.group = group;
            XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
            customSqlList.add(customSql);
        }
        rmoArg.getRespons().addData(customSqlList);
    }

    public String createName(DtsSession dtsSession, int profileId, int entityId, String origName, String namePrefix) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while (true) {
            this.getLogger().debug("newName=" + newName);
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getByName(dtsSession, profileId, newName);
            if (customSql == null) break;
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public static enum Method implements RmiRemoteMethod
    {
        putEntity,
        getEntity,
        deleteEntity,
        getCustomSqlList,
        copyCustomSql;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

