/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxBorderPane;
import ext.scf4.swg.HswgExportWizerd;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class XdtsTableToolPane
extends FxBorderPane {
    Button exportButton;
    TableModel tableModel;
    BcTableColumnModel tableColumnModel;

    public XdtsTableToolPane() throws Exception {
        this.exportButton = new Button(BcWords.getInstance().export);
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        HBox hBox = new HBox(8.0);
        this.exportButton.setOnAction(this.actionEventHandler);
        hBox.getChildren().add((Object)this.exportButton);
        hBox.setAlignment(Pos.CENTER);
        this.setCenter((Node)hBox);
    }

    public void setDataModel(TableModel tableModel, BcTableColumnModel tableColumnModel) throws Exception {
        this.tableModel = tableModel;
        this.tableColumnModel = tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.exportButton) {
            String filePath = System.getProperty("user.home");
            this.export(this.tableModel, this.tableColumnModel, filePath);
        }
    }

    public void export(final TableModel tableModel, final BcTableColumnModel tableColumnModel, final String filePath) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HswgExportWizerd exportWizerd = new HswgExportWizerd();
                    exportWizerd.setData(tableModel, tableColumnModel);
                    exportWizerd.setDestFile(new File(filePath));
                    exportWizerd.start(null);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }
}

