/*
 * Decompiled with CFR 0.152.
 */
package ext.module.conp.dao;

import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.conp.model.ConpScore;
import java.util.List;

public class ConpScoreDAO
extends OrmAbstractDAO<ConpScore> {
    private ConpScoreDAO() {
        super(new ConpScore[0]);
        this.setTableName("conp_score");
    }

    public static ConpScoreDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long gameId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (gameId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "game_id = " + gameId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long gameId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "tos";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, gameId);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> List<T> getListByGameId(DtsSession dtsSession, long gameId) throws Exception {
        return this.getList(dtsSession, Mode.gameId, gameId);
    }

    /* synthetic */ ConpScoreDAO(ConpScoreDAO conpScoreDAO) {
        this();
    }

    public static enum Mode {
        gameId("game_id, ordinal");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final ConpScoreDAO instance = new ConpScoreDAO(null);

        private SingletonHolder() {
        }
    }
}

