/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.task;

import ext.base.event.BcEventHandler;
import ext.base.event.BcEventUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.task.TmpLogger;
import ext.lib.task.TskTaskContext;
import ext.lib.task.TskTaskEvent;
import java.util.concurrent.Callable;
import javax.swing.event.EventListenerList;

public abstract class TskAbstractCallable<T>
extends BcLoggableObject
implements Callable {
    protected TskTaskContext taskContext = new TskTaskContext();
    private Throwable throwable;
    private String name;
    private EventListenerList listenerList = new EventListenerList();

    public TskAbstractCallable() {
        this.setName(this.getClass().getName());
    }

    public TskTaskContext getTaskContext() {
        return this.taskContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final T call() throws Exception {
        this.throwable = null;
        this.taskContext.startTime = System.currentTimeMillis();
        this.taskStarted();
        T respons = null;
        try {
            respons = this.taskProcess();
            this.taskContext.endTime = System.currentTimeMillis();
            this.taskFinished();
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw ex;
        }
        return respons;
    }

    protected abstract T taskProcess() throws Exception;

    protected void taskStarted() {
        TmpLogger tmpLogger = new TmpLogger();
        tmpLogger.setCallabl(this);
        this.getLogger().bind(tmpLogger);
        BcEventUtil.fireEvent((BcEventHandler[])this.listenerList.getListeners(BcEventHandler.class), new TskTaskEvent(this, (Object)TskTaskEvent.EventType.Started), this.getLogger());
    }

    protected void taskFinished() {
        BcEventUtil.fireEvent((BcEventHandler[])this.listenerList.getListeners(BcEventHandler.class), new TskTaskEvent(this, (Object)TskTaskEvent.EventType.Finished), this.getLogger());
        this.getLogger().bind(null);
    }

    protected void handleException(Throwable throwable) {
        this.throwable = throwable;
        this.getLogger().error(BcLogUtil.getStackTrace(throwable));
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addEventHandler(BcEventHandler eventHandler) throws Exception {
        this.listenerList.add(BcEventHandler.class, eventHandler);
    }

    public void removeEventHandler(BcEventHandler eventHandler) throws Exception {
        this.listenerList.remove(BcEventHandler.class, eventHandler);
    }

    public void log(Object log) {
        TskTaskEvent event = new TskTaskEvent(this, (Object)TskTaskEvent.EventType.Log);
        event.setUserObject(log);
        BcEventUtil.fireEvent((BcEventHandler[])this.listenerList.getListeners(BcEventHandler.class), event, this.getLogger());
    }
}

