/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcConstants;
import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcISO;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.KuromojiUtil;
import ext.lib.nlp.NlpAbstractNounFinder;
import ext.lib.nlp.NlpNoun;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NlpPrefectureFinder
extends NlpAbstractNounFinder {
    protected Map<String, NlpNoun> prefecturenMap;
    protected Map<String, NlpNoun> municipalitiesMap;

    public void init() throws Exception {
        NlpNoun noun;
        BcISO.ISO_3166_2_jp iso3166_2_jp;
        this.prefecturenMap = new LinkedHashMap<String, NlpNoun>();
        BcISO.ISO_3166_2_jp[] iSO_3166_2_jpArray = BcISO.ISO_3166_2_jp.values();
        int n = iSO_3166_2_jpArray.length;
        int n2 = 0;
        while (n2 < n) {
            iso3166_2_jp = iSO_3166_2_jpArray[n2];
            noun = new NlpNoun();
            noun.name = noun.key = iso3166_2_jp.name();
            noun.reading = iso3166_2_jp.kana;
            noun.score = -1;
            this.prefecturenMap.put(noun.key, noun);
            ++n2;
        }
        iSO_3166_2_jpArray = BcISO.ISO_3166_2_jp.values();
        n = iSO_3166_2_jpArray.length;
        n2 = 0;
        while (n2 < n) {
            iso3166_2_jp = iSO_3166_2_jpArray[n2];
            noun = new NlpNoun();
            noun.name = noun.key = String.valueOf(iso3166_2_jp.name()) + iso3166_2_jp.suffix;
            noun.reading = iso3166_2_jp.kana;
            if (iso3166_2_jp.suffix.equals("\u770c")) {
                noun.reading = String.valueOf(noun.reading) + "\u30b1\u30f3";
            } else if (iso3166_2_jp.suffix.equals("\u5e9c")) {
                noun.reading = String.valueOf(noun.reading) + "\u30d5";
            } else if (iso3166_2_jp.suffix.equals("\u90fd")) {
                noun.reading = String.valueOf(noun.reading) + "\u30c8";
            }
            noun.score = -1;
            this.prefecturenMap.put(noun.key, noun);
            ++n2;
        }
        this.getLogger().debug("prefecturenMap.size=" + this.prefecturenMap.size());
        BcTableModel tableModel = null;
        Throwable throwable = null;
        Object var3_3 = null;
        try (InputStream is = this.getClass().getResourceAsStream("municipalities_2024-10-08.csv");){
            InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.municipalitiesMap = new LinkedHashMap<String, NlpNoun>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpNoun noun2 = new NlpNoun();
            noun2.name = noun2.key = (String)tableModel.getValueAt(i, 1);
            noun2.reading = (String)tableModel.getValueAt(i, 2);
            noun2.score = 2;
            this.municipalitiesMap.put(noun2.key, noun2);
            ++i;
        }
        this.getLogger().debug("municipalitiesMap.size=" + this.municipalitiesMap.size());
    }

    @Override
    protected NlpNoun getNoun(List<KrmjTokenWrap> tokenWrapList) throws Exception {
        String key;
        NlpNoun noun;
        if (this.prefecturenMap == null) {
            this.init();
        }
        if ((noun = this.prefecturenMap.get(key = KuromojiUtil.toString2(tokenWrapList))) == null) {
            noun = this.municipalitiesMap.get(key);
        }
        return noun;
    }
}

