/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcConstants;
import ext.base.table.BcTableModel;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcKanaUtil;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.KuromojiUtil;
import ext.lib.nlp.NlpAbstractNounFinder;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpPersonNameUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NlpPersonNameFinder2
extends NlpAbstractNounFinder {
    protected Map<String, NlpNoun> lastNameMap;
    protected Map<String, NlpNoun> firstNameManMap;
    protected Map<String, NlpNoun> firstNameWomanMap;
    protected Map<String, NlpNoun> kanaMap;

    public void init() throws Exception {
        NlpNoun noun;
        this.getLogger().debug("ExtNameFinderImpl2 setup...");
        this.lastNameMap = new LinkedHashMap<String, NlpNoun>();
        this.setup_L2(this.lastNameMap, NlpPersonNameUtil.personLastNameDat);
        this.firstNameManMap = new LinkedHashMap<String, NlpNoun>();
        this.setup_L2(this.firstNameManMap, NlpPersonNameUtil.personFirstNameManDat);
        this.firstNameWomanMap = new LinkedHashMap<String, NlpNoun>();
        this.setup_L2(this.firstNameWomanMap, NlpPersonNameUtil.personFirstNameWomanDat);
        this.kanaMap = new LinkedHashMap<String, NlpNoun>();
        for (Map.Entry<String, NlpNoun> mapEentry : this.firstNameManMap.entrySet()) {
            if (this.kanaMap.containsKey(mapEentry.getValue().reading)) continue;
            noun = new NlpNoun();
            noun.name = noun.key = mapEentry.getValue().reading;
            noun.reading = noun.key;
            noun.score = 1;
            this.kanaMap.put(noun.key, noun);
        }
        for (Map.Entry<String, NlpNoun> mapEentry : this.firstNameWomanMap.entrySet()) {
            if (this.kanaMap.containsKey(mapEentry.getValue().reading)) continue;
            noun = new NlpNoun();
            noun.name = noun.key = mapEentry.getValue().reading;
            noun.reading = noun.key;
            noun.score = 1;
            this.kanaMap.put(noun.key, noun);
        }
        this.getLogger().debug("ExtNameFinderImpl2 setup finished.");
    }

    protected void setup_L2(Map<String, NlpNoun> map1, String fileName) throws Exception {
        BcTableModel tableModel = null;
        Throwable throwable = null;
        Object var5_8 = null;
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bais, BcConstants.charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int i = 0;
        while (i < tableModel.getRowCount()) {
            String key = (String)tableModel.getValueAt(i, 1);
            NlpNoun noun = map1.get(key);
            if (noun == null) {
                noun = new NlpNoun();
                noun.name = noun.key = key;
                noun.reading = (String)tableModel.getValueAt(i, 2);
                noun.score = 1;
                map1.put(noun.key, noun);
            } else {
                List<String> valueList = BcCsvUtil.parseCsvRow(noun.reading, false);
                valueList.add((String)tableModel.getValueAt(i, 2));
                noun.reading = BcCsvUtil.toCsv(valueList);
            }
            ++i;
        }
    }

    @Override
    protected NlpNoun getNoun(List<KrmjTokenWrap> tokenWrapList) throws Exception {
        if (this.lastNameMap == null) {
            this.init();
        }
        NlpNoun noun = null;
        int i = 0;
        while (i < tokenWrapList.size() - 1) {
            List<KrmjTokenWrap> tokenWrapList31 = tokenWrapList.subList(0, i + 1);
            String lastName = KuromojiUtil.toString2(tokenWrapList31);
            List<KrmjTokenWrap> tokenWrapList32 = tokenWrapList.subList(i + 1, tokenWrapList.size());
            String firstName = KuromojiUtil.toString2(tokenWrapList32);
            NlpNoun noun_lastName = this.lastNameMap.get(lastName);
            if (noun_lastName != null) {
                NlpNoun noun_firstName = this.firstNameManMap.get(firstName);
                if (noun_firstName == null) {
                    noun_firstName = this.firstNameWomanMap.get(firstName);
                }
                if (noun_firstName == null) {
                    String kana = BcKanaUtil.hanKanaToZenKana(firstName, 2);
                    NlpNoun noun_temp = this.kanaMap.get(kana = BcKanaUtil.hiraganaToZenKana(kana, 2));
                    if (noun_temp != null) {
                        noun_firstName = new NlpNoun();
                        noun_firstName.name = noun_firstName.key = firstName;
                        noun_firstName.reading = noun_temp.reading;
                    }
                }
                if (noun_firstName != null) {
                    noun = new NlpNoun();
                    noun.key = String.valueOf(noun_lastName.key) + noun_firstName.key;
                    noun.name = String.valueOf(noun_lastName.name) + " " + noun_firstName.name;
                    noun.reading = String.valueOf(this.getFirst(noun_lastName.reading)) + " " + this.getFirst(noun_firstName.reading);
                    noun.score = 1;
                    break;
                }
            }
            ++i;
        }
        return noun;
    }

    protected String getFirst(String str) throws Exception {
        List<String> valueList = BcCsvUtil.parseCsvRow(str, false);
        String first = BcCollectionUtil.getFirst(valueList);
        return first;
    }
}

