/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.ipadic.Tokenizer;
import ext.base.core.BcConstants;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpNounFinderImpl;
import ext.lib.nlp.NlpPersonNameFinder1;
import ext.lib.nlp.NlpPersonNameFinder2;
import ext.lib.nlp.NlpPersonNameUtil;
import ext.lib.nlp.NlpPrefectureFinder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NlpBuilder
extends BcLoggableObject {
    private List<File> fileList = new ArrayList<File>();

    public void addFile(File file) throws Exception {
        this.fileList.add(file);
    }

    public NlpNounFinderImpl boild() throws Exception {
        Tokenizer.Builder tokenizerBuilder = new Tokenizer.Builder().mode(TokenizerBase.Mode.NORMAL);
        InputStream is = this.getClass().getResourceAsStream(NlpPersonNameUtil.personNameDat);
        ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
        StringBuilder sb = new StringBuilder();
        sb.append(BcStreamUtil.readAsString((InputStream)bais, BcConstants.charset));
        for (File file : this.fileList) {
            this.getLogger().debug("file=" + file.getPath());
            FileInputStream fis = new FileInputStream(file);
            String str = BcStreamUtil.readAsString((InputStream)fis, BcConstants.charset);
            sb.append(str);
        }
        ByteArrayInputStream bais2 = new ByteArrayInputStream(sb.toString().getBytes(BcConstants.charset));
        tokenizerBuilder.userDictionary((InputStream)bais2);
        Tokenizer tokenizer = tokenizerBuilder.build();
        NlpNounFinderImpl nounFinder = new NlpNounFinderImpl();
        nounFinder.setTokenizer(tokenizer);
        NlpPersonNameFinder1 personNameFinder1 = this.createPersonNameFinder1();
        for (File file : this.fileList) {
            Throwable throwable = null;
            Object var12_14 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                Map<String, NlpNoun> nounMap = NlpPersonNameUtil.createNounMap(fis);
                personNameFinder1.addNounMap(nounMap);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        nounFinder.init();
        nounFinder.nounFinderList.add(personNameFinder1);
        nounFinder.nounFinderList.add(new NlpPersonNameFinder2());
        nounFinder.nounFinderList.add(new NlpPrefectureFinder());
        return nounFinder;
    }

    protected NlpPersonNameFinder1 createPersonNameFinder1() throws Exception {
        NlpPersonNameFinder1 personNameFinder1 = new NlpPersonNameFinder1();
        Throwable throwable = null;
        Object var3_5 = null;
        try (InputStream is = this.getClass().getResourceAsStream(NlpPersonNameUtil.personNameDat);){
            ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
            Map<String, NlpNoun> nounMap = NlpPersonNameUtil.createNounMap(bais);
            personNameFinder1.addNounMap(nounMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return personNameFinder1;
    }
}

