/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.renderer;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.lib.doc.renderer.DcfTextRenderer;
import ext.lib.doc.util.DcfConstants;
import ext.lib.doc.util.DcfDocumentUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import nlc.lib.doc.shape.DcfTextShape;

public class DcfTextShapeRenderer
extends BcLoggableObject
implements Cloneable {
    private DcfTextRenderer textRenderer;

    public DcfTextShapeRenderer(DcfTextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void drawTextShape(Graphics2D g2d, double bx, double by, DcfTextShape textShape) throws Exception {
        if (BcStringUtil.isEmpty(textShape.value) && BcCollectionUtil.isEmpty(textShape.paragraphList)) {
            return;
        }
        if (textShape.font == null) {
            BcLogUtil.debug("drawTextShape:textShape.font=" + textShape.font);
            BcLogUtil.debug("textShape.value=" + textShape.value);
            textShape.font = new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, 9);
        }
        if (textShape.doClip) {
            Rectangle2D.Double rectangle = new Rectangle2D.Double(bx + textShape.getX(), by + textShape.getY(), textShape.getRectangle().width, textShape.getRectangle().height);
            g2d.setClip(rectangle);
        }
        if (textShape.textColor == null) {
            textShape.textColor = DcfConstants.DEFAULT_TEXT_COLOR;
        }
        if (textShape.textOrientation == 2) {
            TextLayout textLayout;
            FontRenderContext fontRenderContext = DcfDocumentUtil.createDefaultFontRenderContext();
            double advance = 0.0;
            boolean fixedHeight = false;
            double charHeight = 0.0;
            double totalHeight = 0.0;
            if (fixedHeight) {
                textLayout = new TextLayout("\u6f22", textShape.font, fontRenderContext);
                advance = textLayout.getAdvance();
                charHeight = textLayout.getAscent() + textLayout.getDescent();
                totalHeight = charHeight * (double)textShape.value.length();
            } else {
                textLayout = new TextLayout("\u6f22", textShape.font, fontRenderContext);
                advance = textLayout.getAdvance();
                charHeight = textLayout.getAscent() + textLayout.getDescent();
                int i = 0;
                while (i < textShape.value.length()) {
                    String charStr = textShape.value.substring(i, i + 1);
                    textLayout = new TextLayout(charStr, textShape.font, fontRenderContext);
                    totalHeight += (double)(textLayout.getAscent() + textLayout.getDescent());
                    ++i;
                }
            }
            double tX = 0.0;
            double tY = 0.0;
            tX = textShape.horizontalAlign == 0 ? textShape.getX() + (textShape.getRectangle().width - advance) / 2.0 : (textShape.horizontalAlign == 4 ? textShape.getX() + textShape.getRectangle().width - advance - textShape.padding : textShape.getX() + textShape.padding);
            tY = textShape.verticalAlign == 0 ? textShape.getY() + (textShape.getRectangle().height - totalHeight) / 2.0 : (textShape.verticalAlign == 3 ? textShape.getY() + textShape.getRectangle().height - totalHeight - textShape.padding : textShape.getY() + textShape.padding);
            g2d.setFont(textShape.font);
            g2d.setColor(textShape.textColor);
            int i = 0;
            while (i < textShape.value.length()) {
                if (!(charHeight * (double)(i + 1) > textShape.getRectangle().height)) {
                    String charStr = textShape.value.substring(i, i + 1);
                    double zX = bx + tX;
                    double zY = by + (tY + charHeight * (double)(i + 1));
                    g2d.drawString(charStr, (float)zX, (float)zY);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            this.textRenderer.drawTextShape(g2d, bx, by, textShape);
        }
    }
}

