/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.renderer;

import ext.base.log.BcLoggableObject;
import ext.lib.awt.AwtImageObserver;
import ext.lib.awt.AwtImageUtil;
import ext.lib.awt.AwtUtil;
import ext.lib.doc.renderer.DcfBarcodeShapeRenderer;
import ext.lib.doc.renderer.DcfShapeRenderingUtil;
import ext.lib.doc.renderer.DcfTextRenderer;
import ext.lib.doc.renderer.DcfTextShapeRenderer;
import ext.lib.doc.util.DcfConstants;
import ext.lib.doc.util.DcfContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;
import nlc.lib.doc.shape.DcfArcShape;
import nlc.lib.doc.shape.DcfEllipseShape;
import nlc.lib.doc.shape.DcfImageShape;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfPolygon;
import nlc.lib.doc.shape.DcfPolygonShape;
import nlc.lib.doc.shape.DcfRectangleShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;

public class DcfShapeRenderer
extends BcLoggableObject {
    private DcfTextRenderer textRenderer;
    private DcfTextShapeRenderer textShapeRenderer;
    private DcfBarcodeShapeRenderer barcodeShapeRenderer;
    private boolean isEdit;

    public DcfTextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public void setTextRenderer(DcfTextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public DcfTextShapeRenderer getTextShapeRenderer() {
        return this.textShapeRenderer;
    }

    public void setTextShapeRenderer(DcfTextShapeRenderer textShapeRenderer) {
        this.textShapeRenderer = textShapeRenderer;
    }

    public DcfBarcodeShapeRenderer getBarcodeShapeRenderer() {
        return this.barcodeShapeRenderer;
    }

    public void setBarcodeShapeRenderer(DcfBarcodeShapeRenderer barcodeShapeRenderer) {
        this.barcodeShapeRenderer = barcodeShapeRenderer;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public DcfShapeRenderer() {
        this.setTextRenderer(new DcfTextRenderer(this));
        this.setTextShapeRenderer(new DcfTextShapeRenderer(this.getTextRenderer()));
        this.setBarcodeShapeRenderer(new DcfBarcodeShapeRenderer(this));
    }

    public void setRenderingHint(Graphics2D g2d) throws Exception {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void drawPage(Graphics2D g2d, double bx, double by, DcfPage dcfPage) throws Exception {
        DcfPage overlayPage;
        this.setRenderingHint(g2d);
        double bx2 = bx + dcfPage.xMargin;
        double by2 = by + dcfPage.yMargin;
        DcfPageFormat pageFormat = dcfPage.getPageFormat();
        int i = 0;
        while (i < dcfPage.getGroupCount()) {
            DcfShapeGroup shapeGroup = dcfPage.getGroup(i);
            this.drawGroup(g2d, bx2, by2, shapeGroup);
            ++i;
        }
        if (dcfPage.isBorder) {
            g2d.setClip((int)(bx + pageFormat.getImageableX()), (int)(by + pageFormat.getImageableY()), (int)dcfPage.getPageFormat().getWidth(), (int)dcfPage.getPageFormat().getHeight());
            g2d.setColor(Color.black);
            g2d.drawRect((int)(bx + pageFormat.getImageableX()), (int)(by + pageFormat.getImageableY()), (int)dcfPage.getPageFormat().getImageableWidth(), (int)dcfPage.getPageFormat().getImageableHeight());
        }
        if ((overlayPage = DcfContext.getInstance().getOverlayPage()) != null) {
            int i2 = 0;
            while (i2 < overlayPage.getGroupCount()) {
                DcfShapeGroup shapeGroup = overlayPage.getGroup(i2);
                this.drawGroup(g2d, bx2, by2, shapeGroup);
                ++i2;
            }
        }
    }

    public void drawGroup(Graphics2D g2d, double bx, double by, DcfShapeGroup shapeGroup) throws Exception {
        double bx2 = bx + shapeGroup.getX();
        double by2 = by + shapeGroup.getY();
        int i = 0;
        while (i < shapeGroup.getShapeCount()) {
            DcfShape shape = shapeGroup.getShape(i);
            AwtUtil.crearClip(g2d);
            if (DcfShapeGroup.class.isAssignableFrom(shape.getClass())) {
                DcfShapeGroup shapeGroup2 = (DcfShapeGroup)shape;
                this.drawGroup(g2d, bx2, by2, shapeGroup2);
            } else if (DcfRectangleShape.class.isAssignableFrom(shape.getClass())) {
                DcfRectangleShape rectangleShape = (DcfRectangleShape)shape;
                this.drawRectangleShape(g2d, bx2, by2, rectangleShape);
                if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                    DcfTextShape textShape = (DcfTextShape)rectangleShape;
                    this.textShapeRenderer.drawTextShape(g2d, bx2, by2, textShape);
                } else if (DcfImageShape.class.isAssignableFrom(shape.getClass())) {
                    DcfImageShape imageShape = (DcfImageShape)rectangleShape;
                    this.drawImageShape(g2d, bx2, by2, imageShape);
                } else if (DcfAbstractBarcodeShape.class.isAssignableFrom(shape.getClass())) {
                    DcfAbstractBarcodeShape barcodeShape = (DcfAbstractBarcodeShape)rectangleShape;
                    this.barcodeShapeRenderer.drawBarcodeShape(g2d, bx2, by2, barcodeShape);
                }
            } else if (DcfLineShape.class.isAssignableFrom(shape.getClass())) {
                DcfLineShape lineShape = (DcfLineShape)shape;
                this.drawLineShape(g2d, bx2, by2, lineShape);
            } else if (DcfEllipseShape.class.isAssignableFrom(shape.getClass())) {
                DcfEllipseShape ellipseShape = (DcfEllipseShape)shape;
                this.drawEllipseShape(g2d, bx2, by2, ellipseShape);
            } else if (DcfArcShape.class.isAssignableFrom(shape.getClass())) {
                DcfArcShape arcShape = (DcfArcShape)shape;
                this.drawArc(g2d, bx2, by2, arcShape);
            } else if (DcfPolygonShape.class.isAssignableFrom(shape.getClass())) {
                DcfPolygonShape polygonShape = (DcfPolygonShape)shape;
                this.drawPolygonShape(g2d, bx2, by2, polygonShape);
            }
            ++i;
        }
    }

    public void drawRectangleShape(Graphics2D g2d, double bx, double by, DcfRectangleShape rectangleShape) throws Exception {
        Rectangle2D.Double rectangle = new Rectangle2D.Double(bx + rectangleShape.getX(), by + rectangleShape.getY(), rectangleShape.getRectangle().width, rectangleShape.getRectangle().height);
        if (rectangleShape.isFill) {
            if (rectangleShape.fillColor != null) {
                g2d.setColor(rectangleShape.fillColor);
            } else if (rectangleShape.lineColor != null) {
                g2d.setColor(rectangleShape.lineColor);
            } else {
                g2d.setColor(DcfConstants.DEFAULT_LINE_COLOR);
            }
            g2d.fill(rectangle);
        }
        if (rectangleShape.lineWidth > 0.0) {
            Stroke stroke = DcfShapeRenderingUtil.createStroke(rectangleShape.lineWidth, rectangleShape.lineType);
            g2d.setStroke(stroke);
            if (rectangleShape.lineColor != null) {
                g2d.setColor(rectangleShape.lineColor);
            } else {
                g2d.setColor(DcfConstants.DEFAULT_LINE_COLOR);
            }
            g2d.draw(rectangle);
        }
        if (this.isEdit) {
            Rectangle2D.Double rectangle2 = new Rectangle2D.Double(bx + rectangleShape.getX(), by + rectangleShape.getY(), rectangleShape.getRectangle().width, rectangleShape.getRectangle().height);
            g2d.setClip(rectangle2);
            g2d.setColor(Color.lightGray);
            g2d.drawRect((int)((RectangularShape)rectangle2).getX(), (int)((RectangularShape)rectangle2).getY(), (int)((RectangularShape)rectangle2).getWidth(), (int)((RectangularShape)rectangle2).getHeight());
        }
    }

    public void drawLineShape(Graphics2D g2d, double bx, double by, DcfLineShape lineShape) throws Exception {
        if (this.isEdit) {
            this.drawLineShape(g2d, bx, by, lineShape.getLine().x1, lineShape.getLine().y1, lineShape.getLine().x2, lineShape.getLine().y2, lineShape.lineWidth, lineShape.lineType, Color.lightGray);
        }
        this.drawLineShape(g2d, bx, by, lineShape.getLine().x1, lineShape.getLine().y1, lineShape.getLine().x2, lineShape.getLine().y2, lineShape.lineWidth, lineShape.lineType, lineShape.lineColor);
    }

    public void drawLineShape(Graphics2D g2d, double bx, double by, double rX1, double rY1, double rX2, double rY2, double rLineWidth, String lineType, Color color) throws Exception {
        if (rLineWidth <= 0.0) {
            return;
        }
        double pX1 = bx + rX1;
        double pY1 = by + rY1;
        double pX2 = bx + rX2;
        double pY2 = by + rY2;
        Stroke stroke = DcfShapeRenderingUtil.createStroke(rLineWidth, lineType);
        Line2D.Double line = new Line2D.Double(pX1, pY1, pX2, pY2);
        g2d.setStroke(stroke);
        if (color != null) {
            g2d.setColor(color);
        } else {
            g2d.setColor(DcfConstants.DEFAULT_LINE_COLOR);
        }
        g2d.draw(line);
    }

    public void drawEllipseShape(Graphics2D g2d, double bx, double by, DcfEllipseShape ellipseShape) throws Exception {
        Ellipse2D.Double ellipse = (Ellipse2D.Double)ellipseShape.getEllipse().clone();
        ellipse.x = bx + ellipse.x;
        ellipse.y = by + ellipse.y;
        g2d.setClip(ellipse);
        g2d.setColor(ellipseShape.lineColor);
        if (ellipseShape.isFill) {
            g2d.fill(ellipse);
        } else {
            g2d.draw(ellipse);
        }
    }

    public void drawArc(Graphics2D g2d, double bx, double by, DcfArcShape arcShape) throws Exception {
        Arc2D.Double arc = (Arc2D.Double)arcShape.getArc().clone();
        arc.x = bx + arc.x;
        arc.y = by + arc.y;
        Stroke stroke = DcfShapeRenderingUtil.createStroke(arcShape.lineWidth, arcShape.lineType);
        g2d.setStroke(stroke);
        g2d.setColor(arcShape.lineColor);
        if (arcShape.isFill) {
            g2d.fill(arc);
        } else {
            g2d.draw(arc);
        }
    }

    public void drawPolygonShape(Graphics2D g2d, double bx, double by, DcfPolygonShape docPolygon) throws Exception {
        Point2D.Double point = docPolygon.getPoint();
        point.x = bx + point.x;
        point.y = by + point.y;
        DcfPolygon polygon = (DcfPolygon)docPolygon.getPolygon().clone();
        int i = 0;
        while (i < polygon.xpoints.length) {
            polygon.xpoints[i] = (int)(bx + point.x + (double)polygon.xpoints[i]);
            ++i;
        }
        i = 0;
        while (i < polygon.ypoints.length) {
            polygon.ypoints[i] = (int)(by + point.y + (double)polygon.ypoints[i]);
            ++i;
        }
        g2d.setClip(polygon);
        g2d.setColor(docPolygon.lineColor);
        if (docPolygon.isFill) {
            g2d.fill(polygon);
        } else {
            g2d.draw(polygon);
        }
    }

    public void drawImageShape(Graphics2D g2d, double bx, double by, DcfImageShape imageShape) throws Exception {
        AwtImageObserver imageObserver = new AwtImageObserver();
        double tWidth = imageShape.getRectangle().width;
        double tHeight = imageShape.getRectangle().height;
        if (tWidth <= 0.0) {
            tWidth = imageShape.getImage().getWidth(imageObserver);
        }
        if (tHeight <= 0.0) {
            tHeight = imageShape.getImage().getHeight(imageObserver);
        }
        double imWidth = 0.0;
        double imHeight = 0.0;
        if (imageShape.isFitToArea()) {
            if (imageShape.isKeepRatio()) {
                Rectangle2D.Double tmpRectangle = AwtImageUtil.calcKeepRatioSize(imageShape.getImage().getWidth(imageObserver), imageShape.getImage().getHeight(imageObserver), tWidth, tHeight);
                imWidth = ((RectangularShape)tmpRectangle).getWidth();
                imHeight = ((RectangularShape)tmpRectangle).getHeight();
            } else {
                imWidth = tWidth;
                imHeight = tHeight;
            }
        } else {
            imWidth = imageShape.getImage().getWidth(imageObserver);
            imHeight = imageShape.getImage().getHeight(imageObserver);
        }
        Rectangle2D.Double clipRectangle = new Rectangle2D.Double(bx + imageShape.getX(), by + imageShape.getY(), imWidth, imHeight);
        g2d.setClip(clipRectangle);
        g2d.drawImage(imageShape.getImage(), (int)(bx + imageShape.getX()), (int)(by + imageShape.getY()), (int)imWidth, (int)imHeight, imageShape.getBgColor(), imageObserver);
    }
}

