/*
 * Decompiled with CFR 0.152.
 */
package ext.base.zip;

import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import ext.base.zip.BcZipUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public final class BcDecompressor {
    protected DecimalFormat decimalFormat = new DecimalFormat();

    public void doDecompress(ZipFile zipFile, List<ZipEntry> zipEntryList, File destDir) throws Exception {
        InnerStreamTransmitter streamTransmitter = new InnerStreamTransmitter();
        int i = 0;
        while (i < zipEntryList.size()) {
            ZipEntry zipEntry = zipEntryList.get(i);
            this.decompressStart(zipEntry, i + 1, zipEntryList.size());
            File destFile = new File(destDir, zipEntry.getName());
            BcFileUtil.makeParent(destFile);
            if (!zipEntry.isDirectory()) {
                BcZipUtil.extract(zipFile, zipEntry, destFile, null);
            }
            ++i;
        }
    }

    public void doDecompress(ZipFile zipFile, File destDir) throws Exception {
        List<ZipEntry> zipEntryList = BcZipUtil.createEntryList(zipFile);
        this.doDecompress(zipFile, zipEntryList, destDir);
    }

    protected void decompressStart(ZipEntry zipEntry, int entryNo, int entryCount) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(zipEntry.getName());
        sb.append(" ");
        sb.append(this.decimalFormat.format(entryNo));
        sb.append("/");
        sb.append(this.decimalFormat.format(entryCount));
        BcLogUtil.debug(sb);
    }

    protected void progressInfo(long value) throws Exception {
    }

    public void progressInfo(long entryCount, long compleeCount) throws Exception {
    }

    class InnerStreamTransmitter
    extends BcStreamTransmitter {
        InnerStreamTransmitter() {
        }

        @Override
        protected void transferd(long value) throws Exception {
            BcDecompressor.this.progressInfo(value);
        }
    }
}

