/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.tagdict;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import opennlp.tools.postag.TagDictionary;

public class MorfologikTagDictionary
implements TagDictionary {
    private IStemmer dictLookup;
    private boolean isCaseSensitive;

    public MorfologikTagDictionary(Dictionary dict) throws IllegalArgumentException, IOException {
        this(dict, true);
    }

    public MorfologikTagDictionary(Dictionary dict, boolean caseSensitive) throws IllegalArgumentException, IOException {
        this.dictLookup = new DictionaryLookup(dict);
        this.isCaseSensitive = caseSensitive;
    }

    public String[] getTags(String word) {
        List data;
        if (!this.isCaseSensitive) {
            word = word.toLowerCase();
        }
        if ((data = this.dictLookup.lookup((CharSequence)word)) != null && data.size() > 0) {
            ArrayList<String> tags = new ArrayList<String>(data.size());
            for (WordData aData : data) {
                tags.add(aData.getTag().toString());
            }
            if (tags.size() > 0) {
                return tags.toArray(new String[tags.size()]);
            }
            return null;
        }
        return null;
    }
}

