/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.dao;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationEvent;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import ext.scf5.dao.ScfSchemaVersionDAO;
import ext.scf5.model.ScfSchemaVersion;

public class KscfDatasourceUpdater
extends TskAbstractCallable {
    protected DtsSession dtsSession;
    protected int startVersion;
    protected int endVersion;

    public void setCondition(DtsSession dtsSession, int startVersion, int endVersion) throws Exception {
        this.dtsSession = dtsSession;
        this.startVersion = startVersion;
        this.endVersion = endVersion;
    }

    public Object taskProcess() throws Exception {
        this.run_L2();
        return null;
    }

    protected void run_L2() throws Exception {
        int tmpVersion = this.startVersion;
        while (true) {
            BcLogUtil.debug("tmpVersion=" + tmpVersion);
            if (tmpVersion == this.endVersion) break;
            this.run_L3(tmpVersion, tmpVersion + 1);
            ++tmpVersion;
        }
        SqlContext sqlContext = this.dtsSession.getSqlContext();
        boolean exist = sqlContext.existTable(this.dtsSession.getConnection(), "ksjf_version");
        if (exist) {
            sqlContext.dropTable(this.dtsSession.getConnection(), "ksjf_version");
        }
        this.dtsSession.commit();
    }

    protected void run_L3(int ver1, int ver2) throws Exception {
        String msg = "Datasource updating...  ver." + ver1 + " -> " + ver2;
        AfbApplication.getInstance().fireEvent(new AfbApplicationEvent(this, 41, msg));
        ScfSchemaVersion schemaVersion = new ScfSchemaVersion();
        schemaVersion.versionId = ver2;
        schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
        ScfSchemaVersionDAO.getInstance().putEntity(this.dtsSession, schemaVersion);
        this.update_L3(ver1, ver2);
        schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
        ScfSchemaVersionDAO.getInstance().putEntity(this.dtsSession, schemaVersion);
        AfbApplication.getInstance().fireEvent(new AfbApplicationEvent(this, 41, null));
    }

    protected void update_L3(int ver1, int ver2) throws Exception {
    }
}

