/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLogUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.task.TskTaskEvent;
import ext.scf4.fx.HfxConsolePane;
import ext.scf4.fx.HfxElapsedTimePanel;
import ext.scf4.fx.HfxMemoryPane;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class TmpMonitorPane
extends FxBorderPane
implements BcEventHandler<TskTaskEvent> {
    protected HfxConsolePane consolePane = new HfxConsolePane();
    protected HBox hBox = new HBox();
    public HfxElapsedTimePanel elapsedTimePanel = new HfxElapsedTimePanel();
    protected HfxMemoryPane memoryPane = new HfxMemoryPane();
    protected String title;
    protected Window ownerWindow;
    protected Stage stage;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TmpMonitorPane() throws Exception {
        this.setCenter((Node)this.consolePane);
        this.hBox.getChildren().addAll((Object[])new Node[]{this.elapsedTimePanel, this.memoryPane});
        this.hBox.setSpacing(10.0);
        this.hBox.setPadding(new Insets(0.0, 0.0, 0.0, 8.0));
        this.setBottom((Node)this.hBox);
        this.setPadding(new Insets(4.0, 4.0, 0.0, 4.0));
        this.elapsedTimePanel.start();
        this.memoryPane.start();
    }

    public void show(Window ownerWindow, boolean isWait) throws Exception {
        this.ownerWindow = ownerWindow;
        this.stage = new Stage(StageStyle.DECORATED);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    TmpMonitorPane.this.windowShown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(480.0);
        this.stage.setMinWidth(280.0);
        this.stage.setMinHeight(160.0);
        this.stage.setResizable(true);
        this.stage.setTitle(this.title);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("gear_64x64.png"));
        if (isWait) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
    }

    public void show(Window ownerWindow) throws Exception {
        this.show(ownerWindow, false);
    }

    public void show() throws Exception {
        if (this.stage != null && this.stage.isShowing()) {
            return;
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TmpMonitorPane.this.show(null, false);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    public void close() throws Exception {
        this.elapsedTimePanel.stop();
        this.stage.close();
        this.stage = null;
    }

    protected void windowShown() throws Exception {
    }

    @Override
    public void handle(final TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Started) {
            this.show();
        } else if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (TmpMonitorPane.this.stage != null) {
                            TmpMonitorPane.this.close();
                        }
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        } else if (event.getEventType() == TskTaskEvent.EventType.Log) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    TmpMonitorPane.this.consolePane.addLine(BcLogUtil.convertMessage(event.getUserObject()));
                }
            });
        }
    }
}

