/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcLangUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.xml.BcXmlUtil;
import ext.scf.common.ScfAbstractModuleContainer;
import ext.scf.common.ScfHandleManager;
import ext.scf.common.ScfHandleManagerImpl;
import ext.scf.rmi.server.RmiServerModule;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ScfServerContainer
extends ScfAbstractModuleContainer {
    private Document configDom;
    private ScfHandleManagerImpl handleManager;
    public RmiServerModule rmiServerModule = new RmiServerModule();

    private ScfServerContainer() {
        Signal signal_TERM = new Signal("TERM");
        Signal.handle(signal_TERM, new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                BcLogUtil.info("signal=" + signal.getName());
                System.exit(0);
            }
        });
        Signal signal_INT = new Signal("INT");
        Signal.handle(signal_INT, new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                BcLogUtil.info("signal=" + signal.getName());
                System.exit(0);
            }
        });
        boolean isCluster = false;
        this.handleManager = new ScfHandleManagerImpl(isCluster);
    }

    public static ScfServerContainer getInstance() {
        return SingletonHolder.instance;
    }

    public Document getConfig() {
        return this.configDom;
    }

    public void setConfig(Document configDom) throws Exception {
        this.configDom = configDom;
        Node handleManagerNode = BcXmlUtil.getNode(configDom, "handleManager");
        if (handleManagerNode != null) {
            this.setConfig_L2(handleManagerNode);
        } else {
            this.setHandleManagerLogger(BcLogConstants.LogLevel.INFO);
        }
    }

    protected void setConfig_L2(Node baseNode) throws Exception {
        String tmpStr = BcXmlUtil.getTextValue(baseNode, "validationInterval");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            long tmpValue = BcNumberUtil.parseLong(tmpStr, -1L);
            this.handleManager.setValidationInterval(tmpValue);
        }
        String logLevelStr = BcXmlUtil.getTextValue(baseNode, "logLevel");
        BcLogConstants.LogLevel logLevel = BcLogConstants.LogLevel.INFO;
        if (!BcStringUtil.isEmpty(logLevelStr)) {
            logLevel = BcLangUtil.getEnumByName(BcLogConstants.LogLevel.class, logLevelStr);
        }
        if (logLevel == null) {
            throw new Exception("'logLevel' is invalid. value=" + logLevelStr);
        }
        this.setHandleManagerLogger(logLevel);
    }

    protected void setHandleManagerLogger(BcLogConstants.LogLevel logLevel) throws Exception {
        if (logLevel != null) {
            String loggerName = "handleManager";
            File logFile = new File(AfbApplication.getInstance().getLogDir(), String.valueOf(loggerName) + ".log");
            BcLogger logger = BcLogUtil.createLogger(loggerName, false, logLevel, false, logFile);
            this.handleManager.setLogger(logger);
        }
    }

    public ScfHandleManager getHandleManager() {
        return this.handleManager;
    }

    public void start() throws Exception {
        this.handleManager.start();
        this.startModule();
    }

    /* synthetic */ ScfServerContainer(ScfServerContainer scfServerContainer) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfServerContainer instance = new ScfServerContainer(null);

        private SingletonHolder() {
        }
    }
}

