/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.server;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.XdtsConstants;
import ext.scf5.dao.ScfAbstractIntPropertyDAO;
import ext.scf5.dao.ZScfPropertyDAOManager;
import java.util.List;

public class XsysDatasourceUpdater
extends BcLoggableObject {
    public void update(DtsSession dtsSession, int version, boolean isMain) throws Exception {
        switch (version) {
            case 1: {
                break;
            }
            case 2: {
                this.sv2(dtsSession);
                break;
            }
            case 3: {
                this.sv3(dtsSession);
                break;
            }
            case 4: {
                this.sv4(dtsSession);
                break;
            }
            case 5: {
                this.sv5(dtsSession);
                break;
            }
            case 6: {
                this.sv6(dtsSession, isMain);
            }
        }
    }

    public static int executeUpdate(SqlConnection sqlConnection, String query) throws Exception {
        BcLogUtil.debug("info=" + query);
        return SqlUtil.executeUpdate(sqlConnection, query);
    }

    void sv2(DtsSession dtsSession) throws Exception {
        String query = "ALTER TABLE xdts_profile ADD COLUMN driver_file_path CHARACTER VARYING";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv3(DtsSession dtsSession) throws Exception {
        String query = "DROP VIEW xdts_custom_sql__v1";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xdts_custom_sql ADD COLUMN group_ CHARACTER VARYING(255)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "CREATE VIEW  xdts_custom_sql__v1 AS SELECT * FROM xdts_custom_sql WHERE sy_noid = -1";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xdts_extraction_condition ADD COLUMN group_ CHARACTER VARYING(255)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv4(DtsSession dtsSession) throws Exception {
        this.sv4_1(dtsSession);
        this.sv4_2(dtsSession);
        this.sv4_3(dtsSession);
        this.sv4_4(dtsSession);
        this.sv4_5(dtsSession);
    }

    void sv4_1(DtsSession dtsSession) throws Exception {
        String query = "ALTER TABLE frwk_sequence_number ALTER COLUMN sequence_name VARCHAR(255)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv4_2(DtsSession dtsSession) throws Exception {
        String query = "CREATE TABLE xfil____________________ (dumy VARCHAR(1))";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv4_3(DtsSession dtsSession) throws Exception {
        String query = "CREATE TABLE xfil_crawl ( id BIGINT NOT NULL,seq INTEGER NOT NULL,name_ VARCHAR(255),directory TEXT,file_extention TEXT,sc_file_extention TEXT,sc_interval_sec INTEGER,sc_top_margin_sec INTEGER,sc_botom_margin_sec INTEGER,sc_capturing_count_max INTEGER,sc_capturing_timing TEXT,sc_capturing_width INTEGER,sc_capturing_height INTEGER,start_date_time DATETIME,end_date_time DATETIME,directory_count BIGINT,file_count BIGINT,note_ TEXT,CONSTRAINT xfil_crawl__k01 PRIMARY KEY (id))";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv4_4(DtsSession dtsSession) throws Exception {
        String query = "CREATE TABLE xfil_entity ( id BIGINT NOT NULL,nid BIGINT NOT NULL,crawl_id BIGINT NOT NULL,crawl_seq INTEGER NOT NULL,scheme_id SMALLINT NOT NULL,drive VARCHAR(255),directory_ TEXT,name_ TEXT NOT NULL,extention_ VARCHAR(16),size_ BIGINT,creation_datetime TIMESTAMP,last_modified_datetime TIMESTAMP,last_access_datetime TIMESTAMP,executable BOOLEAN,readable BOOLEAN,writable BOOLEAN,hidden BOOLEAN,symbolic_link BOOLEAN,entity_type SMALLINT,child_count INTEGER,owner VARCHAR(255),posix_permission VARCHAR(10),width INTEGER,height INTEGER,duration_millis BIGINT,add_datetime TIMESTAMP,thumbnail_flag BOOLEAN,thumbnail_datetime TIMESTAMP,thumbnail_files TEXT,missing_datetime TIMESTAMP,media_info TEXT,error_1 TEXT,error_2 TEXT,create_date INTEGER,create_time INTEGER,update_date INTEGER,update_time INTEGER,short_01 SMALLINT,short_02 SMALLINT,int_01 INTEGER,int_02 INTEGER,text_01 TEXT,text_02 TEXT,CONSTRAINT xfil_entity__k01 PRIMARY KEY (id))";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv4_5(DtsSession dtsSession) throws Exception {
        String query = "CREATE INDEX xfil_entity__K02 ON xfil_entity (nid, id)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "CREATE INDEX xfil_entity__K03 ON xfil_entity (crawl_id)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv5(DtsSession dtsSession) throws Exception {
        String query = "ALTER TABLE xfil_crawl ADD COLUMN missing_count BIGINT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET missing_count = -1";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv6(DtsSession dtsSession, boolean isMain) throws Exception {
        if (isMain) {
            this.sv6_1(dtsSession);
        }
        this.sv6_2(dtsSession);
        this.sv6_3(dtsSession);
        this.sv6_4(dtsSession);
        this.sv6_5(dtsSession);
    }

    void sv6_1(DtsSession dtsSession) throws Exception {
        String tableName = XdtsConstants.TableName.xdts_property.name();
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(tableName);
        int itemId = XdtsConstants.Property.ffprobeFilePath.id;
        String value = propertyDAO2.getValue(dtsSession, itemId);
        this.getLogger().debug("Old Value=" + value);
        value = BcStringUtil.replace((CharSequence)value, "${ROOT}", "${APP}").toString();
        propertyDAO2.putPropertyElement(dtsSession, itemId, value);
        itemId = XdtsConstants.Property.ffmpegFilePath.id;
        value = propertyDAO2.getValue(dtsSession, itemId);
        this.getLogger().debug("Old Value=" + value);
        value = BcStringUtil.replace((CharSequence)value, "${ROOT}", "${APP}").toString();
        propertyDAO2.putPropertyElement(dtsSession, itemId, value);
    }

    void sv6_2(DtsSession dtsSession) throws Exception {
        String query = "CREATE TABLE xfil_index_group (id BIGINT NOT NULL, add_timestamp TIMESTAMP, update_timestamp TIMESTAMP, name_ VARCHAR(255), note_ TEXT, CONSTRAINT xfil_index_group__k01 PRIMARY KEY (id))";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "INSERT INTO xfil_index_group (id, name_, add_timestamp, update_timestamp) VALUES (1, 'Group-1', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "INSERT INTO frwk_sequence_number (sequence_name, sequence_number, lock_flag) VALUES ('xfil_index_group.id', 1, 0)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv6_3(DtsSession dtsSession) throws Exception {
        String query = "CREATE TABLE xfil_crawler (id BIGINT NOT NULL, add_timestamp TIMESTAMP, update_timestamp TIMESTAMP, name_ VARCHAR(255) NOT NULL, index_group_id BIGINT NOT NULL, overwrirte BOOLEAN NOT NULL, file_extention TEXT, target_path TEXT, exclusion_path TEXT, vc_capturing_width INTEGER NOT NULL, vc_capturing_height INTEGER NOT NULL, vc_interval_sec INTEGER NOT NULL, vc_head_margin_sec INTEGER NOT NULL, vc_tail_margin_sec INTEGER NOT NULL, vc_capturing_count_max INTEGER NOT NULL, vc_elapsed_time BOOLEAN NOT NULL, vc_elapsed_time_horizontal_position_id INTEGER NOT NULL, vc_elapsed_time_vertical_position_id INTEGER NOT NULL, note_ TEXT, CONSTRAINT xfil_crawler__k01 PRIMARY KEY (id))";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv6_4(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "ALTER TABLE xfil_crawl ADD COLUMN crawler_id BIGINT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET crawler_id = id";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl ADD COLUMN start_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl ADD COLUMN end_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET start_timestamp = start_date_time";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET end_timestamp = end_date_time";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl ALTER COLUMN crawler_id SET NOT NULL";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET name_ = TO_CHAR(id) WHERE COALESCE(LENGTH(name_), 0) = 0";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl ADD COLUMN status_id SMALLINT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_crawl SET status_id = 2 WHERE end_timestamp Is NOT NULL";
        int cnt = XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        this.getLogger().debug("update cnt=" + cnt);
        query = "UPDATE xfil_crawl SET status_id = 1 WHERE end_timestamp IS NULL";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl ALTER COLUMN status_id SET NOT NULL";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "INSERT INTO xfil_crawler (  id, add_timestamp, update_timestamp, name_, index_group_id, overwrirte, target_path, file_extention, vc_interval_sec, vc_head_margin_sec, vc_tail_margin_sec, vc_capturing_count_max, vc_capturing_width, vc_capturing_height, vc_elapsed_time, vc_elapsed_time_horizontal_position_id, vc_elapsed_time_vertical_position_id) SELECT  id, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, name_, 1, false, directory, file_extention, sc_interval_sec, sc_top_margin_sec, sc_botom_margin_sec, sc_capturing_count_max, sc_capturing_width, sc_capturing_height, false, 0, 3 FROM xfil_crawl";
        cnt = XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        this.getLogger().debug("update cnt=" + cnt);
        query = "ALTER TABLE xfil_crawl DROP COLUMN name_";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN start_date_time";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN end_date_time";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN seq";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_file_extention";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_capturing_timing";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_interval_sec";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_top_margin_sec";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_botom_margin_sec";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_capturing_count_max";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_capturing_width";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_crawl DROP COLUMN sc_capturing_height";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "CREATE INDEX xfil_crawl__k02 ON xfil_crawl (crawler_id)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "SELECT id FROM xfil_crawler ORDER BY id";
        query = sqlContext.setLimit(query, 1);
        Object value = this.getValue(dtsSession, query);
        if (value == null) {
            value = 0;
        }
        query = "INSERT INTO frwk_sequence_number (sequence_name, sequence_number, lock_flag) VALUES ('xfil_crawler.id', " + value + ", 0)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    void sv6_5(DtsSession dtsSession) throws Exception {
        String query = "ALTER TABLE xfil_entity ADD COLUMN add_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_entity SET add_timestamp = add_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN update_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_entity SET update_timestamp = add_timestamp";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity DROP COLUMN add_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN missing_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_entity SET missing_timestamp = missing_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity DROP COLUMN missing_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN thumbnail_timestamp TIMESTAMP";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_entity SET thumbnail_timestamp = thumbnail_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity DROP COLUMN thumbnail_datetime";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN index_group_id BIGINT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "UPDATE xfil_entity SET index_group_id = 1";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN image_files TEXT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN tag TEXT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity ADD COLUMN video_capture_parameter TEXT";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "ALTER TABLE xfil_entity DROP COLUMN crawl_seq";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "DROP INDEX xfil_entity__K03";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "CREATE INDEX xfil_entity__K03 ON xfil_entity (index_group_id)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
        query = "CREATE INDEX xfil_entity__K04 ON xfil_entity (crawl_id)";
        XsysDatasourceUpdater.executeUpdate(dtsSession.getConnection(), query);
    }

    public List getValueList(DtsSession dtsSession, String query) throws Exception {
        this.getLogger().debug("query=" + query);
        List valueList = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                valueList = SqlUtil.getValueList(rs);
            }
            rs.close();
        }
        return valueList;
    }

    public Object getValue(DtsSession dtsSession, String query) throws Exception {
        Object value = null;
        List valueList = this.getValueList(dtsSession, query);
        if (valueList != null) {
            value = valueList.get(0);
        }
        return value;
    }
}

