/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.rmo;

import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.dao.XdtsProfileDAO;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import ext.module.xmmd.model.XmmdModel;
import ext.module.xmmd.server.XmmdServerUtil;

public class XmmdGeneralRMO
extends RmiAbstractRMO {
    public static final String METHOD_putDataModel = "putDataModel";
    public static final String METHOD_getDataModel = "getDataModel";
    public static final String METHOD_putFieldContext = "putFieldContext";

    public void putDataModel(RmiRmoArgument rmoArg) throws Exception {
        XmmdModel xmmdModel = (XmmdModel)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XmmdServerUtil.getInstance().putModel(BcLogUtil.getDefaultLogger(), dtsSession, xmmdModel);
        rmoArg.getRespons().addData(xmmdModel);
    }

    public void getDataModel(RmiRmoArgument rmoArg) throws Exception {
        int schemaId = rmoArg.getRequest().getDataAsInteger();
        String modelName = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("getDataModel:schemaId=" + schemaId + " modelName=" + modelName);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XmmdModel xmmdModel = XmmdServerUtil.getInstance().getModel(dtsSession, schemaId, modelName);
        rmoArg.getRespons().addData(xmmdModel);
    }

    public int doUpdateSql(DtsSession dtsSession, String sql) throws Exception {
        BcLogUtil.debug("doUpdateSql:sql=" + sql);
        int cnt = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            cnt = stmt.executeUpdate(sql);
        }
        return cnt;
    }

    public void test1(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        String profileName = "nls-test";
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSession, profileName);
        DtsSessionFactory dtsSessionFactoryWk = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profile.getDataId(), true);
        Throwable throwable = null;
        Object var7_8 = null;
        try (DtsSession dtsSessionWk = dtsSessionFactoryWk.createSession(this);){
            this.test1_L2(dtsSession, dtsSessionWk);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void test1_L2(DtsSession dtsSession, DtsSession dtsSessionWk) throws Exception {
        SqlContext sqlContext = dtsSessionWk.getSqlContext();
        String tableName = "psni_person_current";
        XmmdModel xmmdModel = XmmdServerUtil.getInstance().createXmmdModel(dtsSessionWk.getConnection(), tableName, true, sqlContext);
        xmmdModel.schemaId = 1;
        BcLogUtil.debug("mmdModel=" + xmmdModel);
        XmmdServerUtil.getInstance().putModel(BcLogUtil.getDefaultLogger(), dtsSession, xmmdModel);
    }
}

