/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.common;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcPair;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.orm.entity.OrmPersistenceEntity;
import ext.lib.sql.SqlUtil;
import ext.module.xmmd.model.XmmdField;
import ext.module.xmmd.model.XmmdIndex;
import ext.module.xmmd.model.XmmdModel;
import ext.module.xmmd.model.YwebFieldContext;
import ext.module.xmmd.model.YwebFieldPack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nlc.module.apcm.fx.Y_ApcmFxUtil3;
import nlc.module.apcm.model.ApcmFieldAnnotation;

public final class XmmdUtil {
    static DtsWordManagerImpl wordManager = new DtsWordManagerImpl();

    private XmmdUtil() {
    }

    public static MmdModel toMmdModel(XmmdModel xmmdModel, MmdModel mmdModel) throws Exception {
        mmdModel.modelName = xmmdModel.logicalName;
        mmdModel.tableName = xmmdModel.logicalName;
        mmdModel.wordCode = xmmdModel.wordCode;
        mmdModel.note = xmmdModel.note;
        int i = 0;
        while (i < xmmdModel.fieldList.size()) {
            XmmdField xmmdField = xmmdModel.fieldList.get(i);
            MmdField mmdField = XmmdUtil.toMmdField(xmmdField);
            mmdModel.addField(mmdField);
            ++i;
        }
        return mmdModel;
    }

    public static MmdModel toMmdModel(XmmdModel xmmdModel) throws Exception {
        MmdModel mmdModel = new MmdModel();
        return XmmdUtil.toMmdModel(xmmdModel, mmdModel);
    }

    public static void toMmdField(XmmdField xmmdField, MmdField mmdField) throws Exception {
        mmdField.columnName = xmmdField.columnName;
        mmdField.sqlTypeId = xmmdField.sqlTypeId;
        mmdField.dataSize = xmmdField.dataSize;
        mmdField.nullable = xmmdField.nullable;
        mmdField.decimalDigit = xmmdField.decimalDigit;
        mmdField.roundingMode = xmmdField.roundingMode;
        mmdField.ordinalPosition = xmmdField.ordinalPosition;
        mmdField.columnCount = xmmdField.columnCount;
        mmdField.rowCount = xmmdField.rowCount;
        mmdField.horizonalAlignment = xmmdField.horizonalAlignment;
        mmdField.verticalAlignment = xmmdField.verticalAlignment;
        mmdField.formatPattern = xmmdField.format;
        mmdField.displayClassName = xmmdField.displayClass;
        mmdField.datasourceConverterClassName = xmmdField.datasourceConverter;
        mmdField.renderingConverterClassName = xmmdField.renderingConverter;
        mmdField.wordCode = xmmdField.wordCode;
        mmdField.note = xmmdField.note;
        mmdField.dataClass = SqlUtil.toJavaType(xmmdField.sqlTypeId);
    }

    public static MmdField toMmdField(XmmdField xmmdField) throws Exception {
        MmdField mmdField = new MmdField();
        XmmdUtil.toMmdField(xmmdField, mmdField);
        return mmdField;
    }

    public static XmmdModel toXmmdModel(MmdModel mmdModel, XmmdModel xmmdModel) throws Exception {
        xmmdModel.schemaId = 1;
        xmmdModel.tableName = mmdModel.tableName;
        xmmdModel.logicalName = mmdModel.modelName;
        xmmdModel.wordCode = mmdModel.wordCode;
        xmmdModel.note = mmdModel.note;
        int i = 0;
        while (i < mmdModel.fieldList.size()) {
            MmdField mmdField = mmdModel.fieldList.get(i);
            XmmdField xmmdField = XmmdUtil.toXmmdField(mmdField);
            xmmdModel.addField(xmmdField);
            ++i;
        }
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            XmmdIndex xmmdIndex = XmmdUtil.toXmmdIndex(mmdIndex, xmmdModel);
            xmmdModel.addIndex(xmmdIndex);
        }
        xmmdModel.primaryIndexName = mmdModel.primaryIndexName;
        return xmmdModel;
    }

    public static XmmdModel toXmmdModel(MmdModel mmdModel) throws Exception {
        XmmdModel xmmdModel = new XmmdModel();
        XmmdUtil.toXmmdModel(mmdModel, xmmdModel);
        return xmmdModel;
    }

    public static void toXmmdField(MmdField mmdField, XmmdField xmmdField) {
        xmmdField.columnName = mmdField.columnName;
        xmmdField.sqlTypeId = mmdField.sqlTypeId;
        xmmdField.dataSize = mmdField.dataSize;
        xmmdField.nullable = mmdField.nullable;
        xmmdField.decimalDigit = mmdField.decimalDigit;
        xmmdField.roundingMode = mmdField.roundingMode;
        xmmdField.ordinalPosition = mmdField.ordinalPosition;
        xmmdField.columnCount = mmdField.columnCount;
        xmmdField.rowCount = mmdField.rowCount;
        xmmdField.horizonalAlignment = mmdField.horizonalAlignment;
        xmmdField.verticalAlignment = mmdField.verticalAlignment;
        xmmdField.format = mmdField.formatPattern;
        xmmdField.displayClass = mmdField.displayClassName;
        xmmdField.datasourceConverter = mmdField.datasourceConverterClassName;
        xmmdField.renderingConverter = mmdField.renderingConverterClassName;
        xmmdField.wordCode = mmdField.wordCode;
        xmmdField.note = mmdField.note;
    }

    public static XmmdField toXmmdField(MmdField mmdField) {
        XmmdField xmmdField = new XmmdField();
        XmmdUtil.toXmmdField(mmdField, xmmdField);
        return xmmdField;
    }

    public static XmmdIndex toXmmdIndex(MmdIndex mmdIndex, XmmdModel xmmdModel) throws Exception {
        XmmdIndex xmmdIndex = new XmmdIndex();
        xmmdIndex.schemaId = xmmdModel.schemaId;
        xmmdIndex.indexName = mmdIndex.name;
        xmmdIndex.isUnique = mmdIndex.isUnique;
        for (MmdIndexElement indexElement : mmdIndex.indexElementList) {
            MmdIndexElement indexElement2 = (MmdIndexElement)indexElement.clone();
            xmmdIndex.indexElementList.add(indexElement2);
        }
        return xmmdIndex;
    }

    public static List<String> toFieldNameList(List<XmmdField> fieldList) {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        int i = 0;
        while (i < fieldList.size()) {
            XmmdField xmmdField = fieldList.get(i);
            fieldNameList.add(xmmdField.columnName);
            ++i;
        }
        return fieldNameList;
    }

    public static String createSelectQuery(XmmdModel xmmdModel) throws Exception {
        String columns = XmmdUtil.createColumns(xmmdModel);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT " + columns + " FROM " + xmmdModel.logicalName);
        return sql.toString();
    }

    public static String createColumns(XmmdModel xmmdModel) throws Exception {
        List<String> columnNameList = XmmdUtil.toColumnNameList(xmmdModel);
        return BcStringUtil.marge(columnNameList, BcStringUtil.COMMA_STR);
    }

    public static List<String> toColumnNameList(XmmdModel xmmdModel) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < xmmdModel.getFieldCount()) {
            XmmdField xmmdField = xmmdModel.getField(i);
            columnNameList.add(xmmdField.columnName);
            ++i;
        }
        return columnNameList;
    }

    public static StringBuilder createInsertQuery(XmmdModel xmmdModel, String lineSep, boolean num) throws Exception {
        String columns = XmmdUtil.createColumns(xmmdModel);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + xmmdModel.logicalName);
        sql.append(lineSep);
        sql.append(" (" + columns + ")");
        sql.append(lineSep);
        sql.append(" VALUES");
        sql.append(lineSep);
        sql.append(" (");
        int i = 0;
        while (i < xmmdModel.getFieldCount()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            if (num) {
                sql.append(Integer.toString(i + 1));
            }
            ++i;
        }
        sql.append(")");
        return sql;
    }

    public static StringBuilder createInsertQuery(XmmdModel xmmdModel) throws Exception {
        return XmmdUtil.createInsertQuery(xmmdModel, "", false);
    }

    public static XmmdModel createXmmdModel(Class entityClass) throws Exception {
        MmdModel mmdModel = MmdUtil.createMmdModel(entityClass);
        XmmdModel xmmdModel = XmmdUtil.toXmmdModel(mmdModel);
        return xmmdModel;
    }

    public static List<Map.Entry<Field, MmdField>> createFieldEntryList(Class entityClass) throws Exception {
        OrmPersistenceEntity persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        ArrayList<Map.Entry<Field, MmdField>> mapEntryList = new ArrayList<Map.Entry<Field, MmdField>>();
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            MmdField mmdField = Y_ApcmFxUtil3.createMmd(field, persistenceEntity, wordManager);
            mmdField.ordinalPosition = i + 1;
            BcPair<Field, MmdField> mapEntry = new BcPair<Field, MmdField>(field, mmdField);
            mapEntryList.add(mapEntry);
            ++i;
        }
        return mapEntryList;
    }

    public static List<YwebFieldContext> createFieldContexList(Class entityClass, Object entity, String entityName) throws Exception {
        OrmPersistenceEntity persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        List<Field> fieldList = MmdUtil.createFieldListWithSuper(entityClass);
        ArrayList<YwebFieldContext> fieldContextList = new ArrayList<YwebFieldContext>();
        int i = 0;
        while (i < fieldList.size()) {
            YwebFieldContext fieldContext = new YwebFieldContext();
            fieldContext.field = fieldList.get(i);
            fieldContext.mmdField = Y_ApcmFxUtil3.createMmd(fieldContext.field, persistenceEntity, wordManager);
            fieldContext.mmdField.ordinalPosition = i + 1;
            fieldContext.entity = entity;
            fieldContext.entityName = entityName;
            fieldContextList.add(fieldContext);
            ++i;
        }
        return fieldContextList;
    }

    public static YwebFieldPack creatFieldPack(Class entityClass, Object entity, String entityName) throws Exception {
        YwebFieldPack fieldPack = new YwebFieldPack();
        fieldPack.fieldContextMap = new HashMap<String, YwebFieldContext>();
        List<YwebFieldContext> fieldContextList = XmmdUtil.createFieldContexList(entityClass, entity, entityName);
        fieldPack.groupList = new ArrayList<List<YwebFieldContext>>();
        ArrayList<YwebFieldContext> fieldContextList2 = null;
        int i = 0;
        while (i < fieldContextList.size()) {
            YwebFieldContext fieldContext = fieldContextList.get(i);
            String mapKey = XmmdUtil.toMapKey(fieldContext);
            fieldPack.fieldContextMap.put(mapKey, fieldContext);
            int arrangement = 0;
            ApcmFieldAnnotation fieldAnnotation = fieldContext.field.getAnnotation(ApcmFieldAnnotation.class);
            if (fieldAnnotation != null) {
                arrangement = BcNumberUtil.parseInt(fieldAnnotation.arrangement(), 0);
            }
            if (arrangement != 1 || fieldContextList2 == null) {
                if (fieldContextList2 != null) {
                    fieldPack.groupList.add((List<YwebFieldContext>)fieldContextList2);
                }
                fieldContextList2 = new ArrayList<YwebFieldContext>();
            }
            fieldContextList2.add(fieldContext);
            ++i;
        }
        fieldPack.groupList.add(fieldContextList2);
        return fieldPack;
    }

    public static YwebFieldPack creatFieldPack(Object entity) throws Exception {
        return XmmdUtil.creatFieldPack(entity.getClass(), entity, entity.getClass().getSimpleName());
    }

    public static String toMapKey(String entityName, String fieldName) throws Exception {
        return String.valueOf(entityName) + "." + fieldName;
    }

    public static String toMapKey(YwebFieldContext fieldContext) throws Exception {
        return XmmdUtil.toMapKey(fieldContext.entityName, fieldContext.field.getName());
    }
}

