/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilConditionSet;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.rmo.XfilCrawlerRMO;
import ext.module.xfil.stub.XfilFileCrawlStub;
import ext.module.xfil.stub.XfilFileCrawlerStub;
import ext.module.xfil.swg.XfilCrawlListPanel;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf5.swg.IswgAbstractDataViewPanel;
import ext.scf5.swg.IswgLoadableTablePanel;
import ext.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;

public class XfilCrawlerListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    public XfilCrawlerListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().crawlerList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionPane.addNodeUnit(conditionSet.keywordUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilAnalysisCondition analysisCondition = conditionPane.conditionSet.getCondition();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilCrawlerRMO.class.getName());
        rmiReq.setMethodName(XfilCrawlerRMO.Method.list.getMethodName());
        rmiReq.addData(analysisCondition);
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;
        SwgButton addButton;
        SwgButton editButton;
        SwgButton deleteButton;
        SwgButton executeButton;
        SwgButton hisoryButton;

        public InnerTablePanel() throws Exception {
            this.setVisualSaveEnavled(true);
            this.addButton = SwgUtil.createAddButton();
            this.addButton.addActionListener(this.actionListener);
            this.tableControlPanel.addControl3(this.addButton);
            this.editButton = SwgUtil.createEditButton();
            this.editButton.addActionListener(this.actionListener);
            this.editButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.editButton);
            this.deleteButton = SwgUtil.createDeleteButton();
            this.deleteButton.addActionListener(this.actionListener);
            this.deleteButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.deleteButton);
            this.executeButton = SwgUtil.createExecuteButton();
            this.executeButton.addActionListener(this.actionListener);
            this.executeButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.executeButton);
            this.hisoryButton = new SwgButton();
            this.hisoryButton.setText(XfilWords.getInstance().crawlHistory.toPlain());
            this.hisoryButton.addActionListener(this.actionListener);
            this.hisoryButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.hisoryButton);
        }

        @Override
        public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
            super.tableColumnReceived(tableLoadTask, tableColumnList, rowSize, tableContext);
        }

        @Override
        protected SwgTableView createTableView() throws Exception {
            SwgTableView tableView = super.createTableView();
            this.addButton.setEnabled(true);
            return tableView;
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                if (tableView.getSelectedRows().length > 0) {
                    this.rowList = SwgTableViewUtil.getRowList(tableView, tableView.getSelectedRows(), XfilConstants.xfil_crawler.id.fullName());
                    this.entityId = (Number)this.rowList.get(0).get(0);
                    this.editButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                    this.executeButton.setEnabled(true);
                    this.hisoryButton.setEnabled(true);
                } else {
                    this.editButton.setEnabled(false);
                    this.deleteButton.setEnabled(false);
                    this.executeButton.setEnabled(false);
                    this.hisoryButton.setEnabled(false);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
            XfilFxHelper.getInstance().openCrawlerPane(this.entityId.longValue());
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            super.actionPerformed2(ev);
            if (ev.getSource() == this.addButton) {
                XfilFxHelper.getInstance().openCrawlerPane(-1L);
            } else if (ev.getSource() == this.editButton) {
                XfilFxHelper.getInstance().openCrawlerPane(this.entityId.longValue());
            } else if (ev.getSource() == this.deleteButton) {
                BcResult result;
                String msg = String.format(BcWords.getInstance().Do_you_want_to_delete, new Object[0]);
                if (JOptionPane.showConfirmDialog(this, msg, BcWords.getInstance().confirmation, 1) == 0 && (result = XfilFileCrawlerStub.getInstance().delete(this.entityId.longValue())).hasError()) {
                    Component messageComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                    SwgOptionPane.showMessageDialog(this, messageComponent, BcWords.getInstance().warning, 2);
                }
            } else if (ev.getSource() == this.executeButton) {
                BcResult result;
                String msg = String.format(BcWords.getInstance().Do_you_want_to_execute, new Object[0]);
                if (SwgOptionPane.showConfirmDialog(this, msg, BcWords.getInstance().confirmation, 0) == 0 && (result = XfilFileCrawlStub.getInstance().fileCrawl2(this.entityId.longValue())).hasError()) {
                    Component msgComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                    SwgOptionPane.showMessageDialog(this, msgComponent, BcWords.getInstance().error, 0);
                }
            } else if (ev.getSource() == this.hisoryButton) {
                XfilCrawlListPanel crawlListPanel = new XfilCrawlListPanel();
                crawlListPanel.init();
                crawlListPanel.sercByCrawlerId(this.entityId.longValue());
                crawlListPanel.showAsFrame();
            }
        }
    }
}

