/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.dao.XfilCrawlerDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilCrawler;
import ext.module.xfil.server.XfilServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfQueryTask;
import java.util.ArrayList;
import java.util.List;

public class XfilCrawlerRMO
extends RmiAbstractRMO<XfilCrawler> {
    String tableName = XfilConstants.TableName.xfil_crawler.name();

    public void put(RmiRmoArgument rmoArg) throws Exception {
        XfilCrawler crawer = (XfilCrawler)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilCrawlerDAO.getInstance().putEntity(dtsSessionWk, crawer);
            dtsSessionWk.commit();
            rmoArg.getRespons().addData(crawer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> void get(RmiRmoArgument rmoArg) throws Exception {
        long entityId = rmoArg.getRequest().getDataAsLong();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            Object entity = XfilCrawlerDAO.getInstance().getById(dtsSessionWk, entityId);
            rmoArg.getRespons().addData(entity);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void delete(RmiRmoArgument rmoArg) throws Exception {
        long entityId = rmoArg.getRequest().getDataAsLong();
        this.getLogger().info("deleteCrawl:.entityId=" + entityId);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            BcResult result = new BcResult();
            XfilCrawler crawler = (XfilCrawler)XfilCrawlerDAO.getInstance().getById(dtsSessionWk, entityId);
            result.setUserObject(result);
            if (crawler != null) {
                BcResult result2 = XfilServerUtil.getInstance().deleteCrawler(dtsSessionWk, -1L, crawler);
                result.addResult(result2);
            } else {
                result.addError(BcWords.getInstance().Target_object_does_not_exist);
            }
            rmoArg.getRespons().addData(result);
            dtsSessionWk.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> void getList(RmiRmoArgument rmoArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            long entityId = -1L;
            String name = null;
            List entityList = XfilCrawlerDAO.getInstance().getList(dtsSessionWk, XfilCrawlerDAO.Mode.id, entityId, name, -1, false);
            rmoArg.getRespons().addData(entityList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void list(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase(selectQuery);
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlConditionParser conditionParser = XfilUtil.createConditionParser(sqlContext);
        if (analysisCondition.registrationPeriodStart > 0 || analysisCondition.registrationPeriodEnd > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".add_timestamp", analysisCondition.registrationPeriodStart, analysisCondition.registrationPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
        SqlWhereElement whereElement1 = new SqlWhereElement();
        SqlWhereElement whereElementWk = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".name_", String.valueOf(this.tableName) + ".name_", analysisCondition.keyword, null, false);
        if (whereElementWk != null) {
            whereElementWk.setLogical_OR();
            whereElement1.whereElementList.add(whereElementWk);
        }
        if ((whereElementWk = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".file_extention", String.valueOf(this.tableName) + ".file_extention", analysisCondition.keyword, null, false)) != null) {
            whereElementWk.setLogical_OR();
            whereElement1.whereElementList.add(whereElementWk);
        }
        if ((whereElementWk = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".target_path", String.valueOf(this.tableName) + ".target_path", analysisCondition.keyword, null, false)) != null) {
            whereElementWk.setLogical_OR();
            whereElement1.whereElementList.add(whereElementWk);
        }
        if ((whereElementWk = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".exclusion_path", String.valueOf(this.tableName) + ".exclusion_path", analysisCondition.keyword, null, false)) != null) {
            whereElementWk.setLogical_OR();
            whereElement1.whereElementList.add(whereElementWk);
        }
        if ((whereElementWk = conditionParser.parseCondition1(sqlContext, String.valueOf(this.tableName) + ".note_", String.valueOf(this.tableName) + ".note_", analysisCondition.keyword, null, false)) != null) {
            whereElementWk.setLogical_OR();
            whereElement1.whereElementList.add(whereElementWk);
        }
        selectQuery.addWhereElement(whereElement1);
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "name_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "overwrirte"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "file_extention"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "target_path"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "exclusion_path"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "note_"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectQuery selectQuery) {
        selectQuery.getOrderByList().add(String.valueOf(this.tableName) + ".id");
    }

    public static enum Method implements RmiRemoteMethod
    {
        put,
        get,
        delete,
        getList,
        list;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

