/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.mmd.MmdModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcWords;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.tree.FxTreeCell;
import ext.lib.fx.tree.FxTreeFolder;
import ext.lib.fx.tree.FxTreeItem;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.sql.SqlWords;
import ext.lib.sql.model.SqlSelectQuery;
import ext.module.xdts.common.EtcSqlConditionUtil;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsExtractionConditionCreator;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsDefinitionCreatePane;
import ext.module.xdts.fx.XdtsPersistence;
import ext.module.xdts.fx.XdtsProfileTreeItemHelper;
import ext.module.xdts.fx.XdtsTransferPane;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.model.XdtsUserSetting;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.stub.XdtsSchemaStub;
import ext.module.xdts.swg.XdtsDataViewPanel_Auto;
import ext.module.xdts.swg.XdtsDataViewPanel_Sql;
import ext.module.xmmd.model.XmmdModel;
import ext.module.xmmd.stub.XmmdModelStub;
import ext.scf6.fx.TmpTableViewPane;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.input.MouseEvent;

class XdtsTableTreeItemHelper
extends XdtsProfileTreeItemHelper {
    List<XdtsSchemaObject> schemaObjectList;
    ContextMenu contextMenu1;
    ContextMenu contextMenu2;
    MenuItem deleteMenuItem;
    MenuItem refreshMenuItem;
    MenuItem dataViewConditionMenuItem;
    MenuItem dataViewSqlMenuItem;
    MenuItem trancateMenuItem;
    MenuItem tableManipulationMenuItem;
    MenuItem createCreateTableSqlMenuItem;
    MenuItem createInsertSqlMenuItem;
    MenuItem copyToOtherDbMenuItem;
    MenuItem createDefinitionMenuItem;
    MenuItem countSizeMenuItem;
    MenuItem createModelMenuItem;

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(BcWords.getInstance().table));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("tables_64x64.png"));
        return treeItem;
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (XdtsSchemaObject.class.isInstance(treeItem.getValue())) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            str = XdtsUtil.apendLogicalName(this.wordManager, schemaObject.name1);
        } else {
            str = super.getItemText(treeItem);
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        super.refresh();
        this.initTree();
    }

    protected void initTree() throws Exception {
        List<String> tableNameList = XdtsSchemaStub.getInstance().getTableNameList(this.profile.getDataId());
        List<XdtsSchemaObject> schemaObjectList = XdtsUtil.toSchemaObjectList(tableNameList, XdtsConstants.SchemaObjectType.table, true);
        this.setSchemaObjectList(schemaObjectList);
    }

    protected void setSchemaObjectList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        this.schemaObjectList = schemaObjectList;
        this.getSubTreeItem().getChildren().clear();
        ArrayList<FxTreeItem> treeItemList = new ArrayList<FxTreeItem>();
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            FxTreeItem treeItem = this.creaeTreeItem();
            treeItem.setValue(schemaObject);
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
            treeItemList.add(treeItem);
            ++i;
        }
        this.getSubTreeItem().getChildren().addAll(treeItemList);
        String str = String.format(String.valueOf(BcWords.getInstance().table) + "(%d)", treeItemList.size());
        this.getSubTreeItem().setValue(new FxTreeFolder(str));
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        super.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        if (treeItem.getParent() == this.getSubTreeItem() && doubleClicked) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            this.profileTreeView.parentPane.profilePane.addTable(schemaObject.name1, -1);
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu1 == null) {
            this.contextMenu1 = new ContextMenu();
            this.contextMenu2 = new ContextMenu();
            this.deleteMenuItem = new MenuItem(String.valueOf(BcWords.getInstance().delete) + "(" + SqlWords.getInstance().sql_DROP_TABLE + ")", (Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
            this.deleteMenuItem.setOnAction(contextMeneEventHandler);
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewConditionMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Condition, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewConditionMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewSqlMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Sql, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.trancateMenuItem = new MenuItem(SqlWords.getInstance().sql_TRUNCATE_TABLE, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.trancateMenuItem.setOnAction(contextMeneEventHandler);
            this.tableManipulationMenuItem = new MenuItem(XdtsWords.getInstance().GRANT_REVOKE_etc, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.tableManipulationMenuItem.setOnAction(contextMeneEventHandler);
            this.createCreateTableSqlMenuItem = new MenuItem(XdtsWords.getInstance().createCreateTableSql, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.createCreateTableSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.createInsertSqlMenuItem = new MenuItem(XdtsWords.getInstance().createInsertSql, (Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            this.createInsertSqlMenuItem.setOnAction(contextMeneEventHandler);
            this.copyToOtherDbMenuItem = new MenuItem(XdtsWords.getInstance().copyToOtherDb, (Node)FxImageHelper.createImageView_icon("db_copy_64x64.png"));
            this.copyToOtherDbMenuItem.setOnAction(contextMeneEventHandler);
            this.countSizeMenuItem = new MenuItem(XdtsWords.getInstance().numberOfRows_size.toPlain(), (Node)FxImageHelper.createImageView_icon("calculator_64x64.png"));
            this.countSizeMenuItem.setOnAction(contextMeneEventHandler);
            this.createDefinitionMenuItem = new MenuItem(XdtsWords.getInstance().cretaeTableDefinition, (Node)FxImageHelper.createImageView_icon("document_64x64.png"));
            this.createDefinitionMenuItem.setOnAction(contextMeneEventHandler);
            this.createModelMenuItem = new MenuItem("\u30e2\u30c7\u30eb\u4f5c\u6210", (Node)FxImageHelper.createImageView_icon("db_64x64.png"));
            this.createModelMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.deleteMenuItem.setUserData((Object)treeCell);
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.dataViewConditionMenuItem.setUserData((Object)treeCell);
        this.dataViewSqlMenuItem.setUserData((Object)treeCell);
        this.trancateMenuItem.setUserData((Object)treeCell);
        this.tableManipulationMenuItem.setUserData((Object)treeCell);
        this.createInsertSqlMenuItem.setUserData((Object)treeCell);
        this.createCreateTableSqlMenuItem.setUserData((Object)treeCell);
        this.copyToOtherDbMenuItem.setUserData((Object)treeCell);
        this.countSizeMenuItem.setUserData((Object)treeCell);
        this.createDefinitionMenuItem.setUserData((Object)treeCell);
        this.createModelMenuItem.setUserData((Object)treeCell);
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu1.getItems().clear();
            this.contextMenu1.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu1.getItems().add((Object)this.trancateMenuItem);
            this.contextMenu1.getItems().add((Object)this.tableManipulationMenuItem);
            this.contextMenu1.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu1.getItems().add((Object)this.createCreateTableSqlMenuItem);
            this.contextMenu1.getItems().add((Object)this.createInsertSqlMenuItem);
            this.contextMenu1.getItems().add((Object)this.copyToOtherDbMenuItem);
            this.contextMenu1.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu1.getItems().add((Object)this.countSizeMenuItem);
            if (XdtsConstants.isTableDefinition()) {
                this.contextMenu1.getItems().add((Object)this.createDefinitionMenuItem);
            }
            this.contextMenu1.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu1.getItems().add((Object)this.refreshMenuItem);
            treeCell.setContextMenu(this.contextMenu1);
        } else {
            this.contextMenu2.getItems().clear();
            this.contextMenu2.getItems().add((Object)this.dataViewConditionMenuItem);
            this.contextMenu2.getItems().add((Object)this.dataViewSqlMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu2.getItems().add((Object)this.trancateMenuItem);
            this.contextMenu2.getItems().add((Object)this.tableManipulationMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.createCreateTableSqlMenuItem);
            this.contextMenu2.getItems().add((Object)this.createInsertSqlMenuItem);
            this.contextMenu2.getItems().add((Object)this.copyToOtherDbMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.countSizeMenuItem);
            if (XdtsConstants.isTableDefinition()) {
                this.contextMenu2.getItems().add((Object)this.createDefinitionMenuItem);
            }
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.refreshMenuItem);
            treeCell.setContextMenu(this.contextMenu2);
        }
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.refreshMenuItem) {
            this.initTree();
        } else if (ev.getSource() == this.dataViewConditionMenuItem) {
            String fileName2;
            XdtsUserSetting userSetting;
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            XdtsProcessCondition processCondition = new XdtsProcessCondition();
            processCondition.profileId = this.profile.getDataId();
            MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(this.profile.getDataId(), schemaObject.name1);
            String fileName1 = XdtsPersistence.createFileName(this.profile.getDataId(), XdtsConstants.Category.dev, mmdModel.tableName, XdtsConstants.FileType.def);
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)XdtsPersistence.readObject(fileName1);
            if (extractionCondition == null) {
                extractionCondition = XdtsExtractionConditionCreator.createExtractionCondition(this.sqlContext, mmdModel);
            }
            if ((userSetting = (XdtsUserSetting)XdtsPersistence.readObject(fileName2 = XdtsPersistence.createFileName(this.profile.getDataId(), XdtsConstants.Category.dev, mmdModel.tableName, XdtsConstants.FileType.user))) == null) {
                userSetting = new XdtsUserSetting();
            }
            XdtsDataViewPanel_Auto dataViewPanel = new XdtsDataViewPanel_Auto();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setData(extractionCondition, userSetting, true);
            dataViewPanel.setTitle(String.valueOf(this.profile.name) + " : " + schemaObject.name1);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.dataViewSqlMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(this.profile.getDataId(), schemaObject.name1);
            SqlSelectQuery selectQuery = EtcSqlConditionUtil.createSelectQuery(this.sqlContext, mmdModel);
            XdtsCustomSql customSql = new XdtsCustomSql();
            customSql.sql = this.sqlContext.buildSelectQuery(selectQuery).toString();
            customSql.name = String.valueOf(this.profile.name) + " : " + schemaObject.name1;
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.deleteMenuItem || ev.getSource() == this.trancateMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            if (ev.getSource() == this.deleteMenuItem) {
                transferPane.setProfile(this.profile, XdtsTransferPane.Mode.dropTable);
            } else if (ev.getSource() == this.trancateMenuItem) {
                transferPane.setProfile(this.profile, XdtsTransferPane.Mode.truncateTable);
            }
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.tableManipulationMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.tableManipulation);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createCreateTableSqlMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.createCreateTableSql);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createInsertSqlMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.createInsertSql);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.copyToOtherDbMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            transferPane.setProfile(this.profile, XdtsTransferPane.Mode.copyToOtherDb);
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.createDefinitionMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsDefinitionCreatePane definitionCreatePane = new XdtsDefinitionCreatePane(this.profile);
            definitionCreatePane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            definitionCreatePane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.countSizeMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            BcTableModel tableModel = XdtsSchemaStub.getInstance().countSize(this.profile.getDataId(), selectedSchemaObjectList, this.getTreeView().getScene().getWindow());
            FxTableView tableView = new FxTableView();
            FxTableUtil.createColumn(tableModel.getTableColumnModel(), tableView, null);
            FxTableRowList tableRowList = new FxTableRowList(tableModel);
            tableView.setItems(tableRowList);
            TmpTableViewPane tmpTableViewPane = new TmpTableViewPane();
            tmpTableViewPane.setTableView(tableView);
            tmpTableViewPane.tableControlPane.setData(tableModel.getTableColumnModel(), tableModel, null);
            tmpTableViewPane.tableControlPane.setTitle(this.countSizeMenuItem.getText());
            Tab tab = new Tab();
            tab.setText(tmpTableViewPane.tableControlPane.getTitle());
            tab.setContent((Node)tmpTableViewPane);
            tab.closableProperty().set(true);
            this.profileTreeView.parentPane.profilePane.tabPane1.getTabs().add((Object)tab);
            this.profileTreeView.parentPane.profilePane.tabPane1.getSelectionModel().select((Object)tab);
        } else if (ev.getSource() == this.createModelMenuItem) {
            XdtsTableTreeItemHelper.modelCreateTest(this.profile, this.schemaObjectList);
        } else if (ev.getSource() == this.refreshMenuItem) {
            this.refresh();
        }
    }

    public List<XdtsSchemaObject> getSelectedSchemaObjectList(FxTreeItem treeItem) throws Exception {
        List<XdtsSchemaObject> selectedSchemaObject = null;
        if (treeItem == this.getSubTreeItem()) {
            selectedSchemaObject = this.schemaObjectList;
        } else {
            selectedSchemaObject = new ArrayList<XdtsSchemaObject>();
            ObservableList treeItemList = this.getTreeView().getSelectionModel().getSelectedItems();
            int i = 0;
            while (i < treeItemList.size()) {
                FxTreeItem treeItemWk = (FxTreeItem)((Object)treeItemList.get(i));
                if (treeItemWk.getParent() == this.getSubTreeItem()) {
                    XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItemWk.getValue();
                    selectedSchemaObject.add(schemaObject);
                }
                ++i;
            }
        }
        return selectedSchemaObject;
    }

    public static void modelCreateTest(XdtsProfile profile, List<XdtsSchemaObject> tableObjectList) throws Exception {
        List<String> objectNameList = XdtsUtil.toNameList(tableObjectList);
        Map<String, XmmdModel> xmmdMap = XdtsSchemaStub.getInstance().getXmmdModelMap(profile.getDataId(), objectNameList);
        int i = 0;
        while (i < objectNameList.size()) {
            String shemaObjectName = objectNameList.get(i);
            XmmdModel xmmdModel = xmmdMap.get(shemaObjectName);
            XmmdModelStub.getInstance().putDataModel(xmmdModel);
            ++i;
        }
    }
}

