/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.event.BcEvent;
import ext.base.event.BcEventManager;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.layout.FxTitledPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsConditionModelToFx;
import ext.module.xdts.fx.XdtsControlUnit;
import ext.module.xdts.fx.XdtsFxCondition;
import ext.module.xdts.fx.XdtsFxToConditionModel;
import ext.module.xdts.fx.Y_ConditonEvent;
import ext.module.xdts.fx.Y_FxErrorHandle;
import ext.module.xdts.model.XdtsUserSetting;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import ext.module.xdts.stub.XdtsExtractionConditionStub;
import ext.module.xsys.validation.XsysValidator;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsExtractionConditionEditPane
extends FxDecoratePane {
    FxBorderPane centerPane = new FxBorderPane();
    FxFlowPane topPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    TabPane tabPane = new TabPane();
    FxButton completionButton;
    FxButton cancelButton;
    Stage stage;
    SqlContext sqlContext;
    XdtsExtractionCondition extractionCondition;
    protected Y_FxErrorHandle.Silent<Y_ConditonEvent> conditonEventHandler = new Y_FxErrorHandle.Silent<Y_ConditonEvent>(){

        @Override
        public void handle(Y_ConditonEvent ev) throws Exception {
            XdtsExtractionConditionEditPane.this.repaint();
        }
    };
    EventHandler<Y_ConditonEvent> conditonEventHandler1 = Y_FxErrorHandle.wrap(this.conditonEventHandler);
    XdtsConditionModelToFx conditionModelToFx = new XdtsConditionModelToFx();
    XdtsFxCondition fxConditionBase;

    public XdtsExtractionConditionEditPane() throws Exception {
        this.nameTextField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().extractionConditionName), new Node[]{this.nameTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.groupTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefHeight(60.0);
        this.setTop((Node)this.topPane);
        this.centerPane.setCenter((Node)this.tabPane);
        this.setCenter((Node)this.centerPane);
        this.completionButton = FxUtil.createCompletionButton();
        this.completionButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.completionButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.cancelButton);
        FxUtil.defaultInitialize((Node)this);
    }

    public void conditionEdit1_L3(SqlContext sqlContext, XdtsExtractionCondition extractionCondition) throws Exception {
        this.sqlContext = sqlContext;
        this.extractionCondition = extractionCondition;
        XdtsUserSetting userSetting = new XdtsUserSetting();
        this.fxConditionBase = this.conditionModelToFx.createFxCondition(extractionCondition, userSetting, true);
        this.repaint();
    }

    public void repaint() throws Exception {
        this.nameTextField.setText(this.extractionCondition.name);
        this.groupTextField.setText(this.extractionCondition.group);
        this.noteTextField.setText(this.extractionCondition.note);
        this.tabPane.getTabs().clear();
        int i = 0;
        while (i < this.extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = this.extractionCondition.selectContextList.get(i);
            Tab tab = new Tab();
            tab.setClosable(false);
            if (selectContext.id == 0) {
                tab.setText("Main SQL");
            } else {
                tab.setText(XdtsSqlParserUtil.toSubSelectName(selectContext.id));
            }
            this.tabPane.getTabs().add((Object)tab);
            Node node = this.repaint_L2(selectContext);
            tab.setContent(node);
            ++i;
        }
        FxUtil.defaultInitialize((Node)this);
    }

    protected Node repaint_L2(XdtsSelectContext selectContext) throws Exception {
        List<XdtsControlUnit> controlUnitList1 = this.fxConditionBase.controlUnitMap1.get(selectContext.id);
        FxFlowPane flowPane1 = new FxFlowPane(11);
        FxFlowPane flowPane2 = new FxFlowPane(11);
        List<XdtsControlUnit> controlUnitList2 = XdtsConditionModelToFx.sortControlUnit(controlUnitList1, false);
        for (XdtsControlUnit controlUnit : controlUnitList2) {
            if (controlUnit.controlContext.displayOrder > 0) {
                flowPane1.addNodeUnit(controlUnit.nodeUnit);
                continue;
            }
            flowPane2.addNodeUnit(controlUnit.nodeUnit);
        }
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setTitle(BcWords.getInstance().display);
        titledPane1.setContentNode((Node)flowPane1);
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setTitle(BcWords.getInstance().hidden);
        titledPane2.setContentNode((Node)flowPane2);
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.VERTICAL);
        splitPane.getItems().addAll((Object[])new Node[]{titledPane1, titledPane2});
        splitPane.setDividerPositions(new double[]{0.4f, 0.6f});
        return splitPane;
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.completionButton) {
            this.extractionCondition.name = this.nameTextField.getText();
            this.extractionCondition.group = this.groupTextField.getText();
            this.extractionCondition.note = this.noteTextField.getText();
            XsysValidator validator = XsysValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.extractionCondition);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().error, 0);
                return;
            }
            XdtsUserSetting userSetting = new XdtsUserSetting();
            XdtsFxToConditionModel fxToConditionModel = new XdtsFxToConditionModel();
            fxToConditionModel.storeData(this.sqlContext, this.extractionCondition, this.fxConditionBase, userSetting);
            XdtsExtractionCondition extractionCondition2 = XdtsExtractionConditionStub.getInstance().putEntity(this.extractionCondition);
            BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).fireEvent(new BcEvent(this.extractionCondition));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void close() {
        this.stage.close();
    }

    public void show() throws Exception {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
            return;
        }
        this.stage = new FxStage();
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsExtractionConditionEditPane.this.close();
                }
                catch (Exception ex) {
                    XdtsExtractionConditionEditPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(true);
        FxUtil.setWindowCenter((Window)this.stage, 0.8);
        this.stage.setTitle(XdtsWords.getInstance().createExtractionConditions);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("form_64x64.png"));
        this.stage.show();
    }
}

