/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.EtcSqlConditionUtil;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectColumn;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import ext.module.xdts.model.v0001.XdtsSelectElemet;
import java.util.ArrayList;
import java.util.List;

public class XdtsExtractionConditionCreator
extends BcLoggableObject {
    private XdtsExtractionConditionCreator() {
    }

    public static XdtsExtractionCondition createExtractionCondition(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.name = mmdModel.tableName;
        extractionCondition.sqlTemplate = extractionCondition.sqlOrign = "SELECT * FROM " + mmdModel.tableName;
        extractionCondition.selectContextList = new ArrayList<XdtsSelectContext>();
        XdtsSelectContext selectContext = new XdtsSelectContext();
        extractionCondition.selectContextList.add(selectContext);
        selectContext.controlContextList = new ArrayList<XdtsControlContext>();
        selectContext.selectColumnList = new ArrayList<XdtsSelectColumn>();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        int i = 0;
        while (i < tableColumnNameList.size()) {
            String tableColumnName = tableColumnNameList.get(i);
            XdtsSelectColumn selectColumn = XdtsExtractionConditionCreator.toSelectColumn(tableColumnName);
            selectColumn.order = i + 1;
            selectContext.selectColumnList.add(selectColumn);
            ++i;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createFromContext();
        XdtsSelectElemet selectElemet = new XdtsSelectElemet();
        selectElemet.template = selectElemet.orign = mmdModel.tableName;
        selectContext.from = selectElemet;
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        selectContext.whereBase = selectElemet = new XdtsSelectElemet();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createOrderByContext();
        selectContext.orderByList = XdtsExtractionConditionCreator.createOrderByList(mmdModel);
        if (selectContext.orderByList.size() > 0) {
            MmdIndex mmdIndex = selectContext.orderByList.get(0);
            controlContext.defaultValue = EtcSqlConditionUtil.createIndex(mmdIndex);
        }
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createRowLimitContext();
        selectContext.controlContextList.add(controlContext);
        List<XdtsControlContext> controlContextList = XdtsSqlParserUtil.createControlContextList(mmdModel.fieldList);
        selectContext.controlContextList.addAll(controlContextList);
        return extractionCondition;
    }

    public static XdtsSelectColumn toSelectColumn(String src) throws Exception {
        XdtsSelectColumn selectColumn = new XdtsSelectColumn();
        selectColumn.tableColumnName = new XdtsSelectElemet();
        selectColumn.tableColumnName.template = src;
        return selectColumn;
    }

    public static List<MmdIndex> createOrderByList(MmdModel mmdModel) throws Exception {
        ArrayList<MmdIndex> orderByList = new ArrayList<MmdIndex>();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            MmdIndex mmdIndex2 = (MmdIndex)primaryKey.clone();
            orderByList.add(mmdIndex2);
        }
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            MmdIndex mmdIndex2 = (MmdIndex)mmdIndex.clone();
            orderByList.add(mmdIndex2);
        }
        return orderByList;
    }
}

