/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Contact;
import java.util.List;

public class Wbs1ContactDAO
extends OrmAbstractDAO<Wbs1Contact> {
    public static final int MODE_default = 1;

    private Wbs1ContactDAO() {
        super(new Wbs1Contact[0]);
        this.setTableName("wbs1_contact");
    }

    public static Wbs1ContactDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, int personId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (personId > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + personId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public List<Wbs1Contact> getList(DtsSession dtsSession, int personId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, personId);
        String sq = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + sq);
        return this.getEntityList(dtsSession, sq);
    }

    public Wbs1Contact getByPersonId(DtsSession dtsSession, int personId) throws Exception {
        if (personId <= 0) {
            return null;
        }
        List<Wbs1Contact> entityList = this.getList(dtsSession, personId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1ContactDAO(Wbs1ContactDAO wbs1ContactDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1ContactDAO instance = new Wbs1ContactDAO(null);

        private SingletonHolder() {
        }
    }
}

