/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.core.BcConstants;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.dao.Wbs1AccountDAO;
import ext.module.wbs1.model.Wbs1Answer;
import ext.module.wbs1.model.WbsRecruitmentCondition;
import java.util.List;

public class Wbs1AnswerDAO
extends OrmAbstractDAO<Wbs1Answer> {
    private Wbs1AnswerDAO() {
        super(new Wbs1Answer[0]);
        this.setTableName("wbs1_answer");
    }

    public static Wbs1AnswerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (recruitmentCondition.personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + recruitmentCondition.personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (recruitmentCondition.questionSetId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "question_set_id =" + recruitmentCondition.questionSetId);
            selectQuery.addWhereElement(whereElement);
        }
        if (recruitmentCondition.judgementStatusId == BcConstants.Existence.FALSE.value) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "judgement_datetime Is null");
            selectQuery.addWhereElement(whereElement);
        } else if (recruitmentCondition.judgementStatusId == BcConstants.Existence.TRUE.value) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "judgement_datetime Is Not null");
            selectQuery.addWhereElement(whereElement);
        }
        if (recruitmentCondition.sex != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("ac.sex_code" + sqlContext.toCondition_string("=", recruitmentCondition.sex.code));
            selectQuery.addWhereElement(whereElement);
        }
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(String.valueOf(this.getTableName()) + " AS " + alias);
        if (recruitmentCondition.sex != null) {
            fromClause.append(" LEFT JOIN " + Wbs1AccountDAO.getInstance().getTableName() + " AS ac ON ac.person_id = " + aliasWk + "person_id");
        }
        selectQuery.setFromClause(fromClause.toString());
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, recruitmentCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByPersonId(DtsSession dtsSession, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        if (recruitmentCondition.personId <= 0L) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, Mode.personId, recruitmentCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1AnswerDAO(Wbs1AnswerDAO wbs1AnswerDAO) {
        this();
    }

    public static enum Mode {
        personId("person_id"),
        question_set_id("question_set_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1AnswerDAO instance = new Wbs1AnswerDAO(null);

        private SingletonHolder() {
        }
    }
}

