/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Account;
import ext.module.wbs1.model.WbsRecruitmentCondition;
import java.util.List;

public class Wbs1AccountDAO
extends OrmAbstractDAO<Wbs1Account> {
    private Wbs1AccountDAO() {
        super(new Wbs1Account[0]);
        this.setTableName("wbs1_account");
    }

    public static Wbs1AccountDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (!BcStringUtil.isEmpty(recruitmentCondition.loginId)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "login_id" + sqlContext.toCondition_string("=", recruitmentCondition.loginId));
            selectQuery.addWhereElement(whereElement);
        }
        if (recruitmentCondition.personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + recruitmentCondition.personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(recruitmentCondition.temporaryId)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "temporary_id" + sqlContext.toCondition_string("=", recruitmentCondition.temporaryId));
            selectQuery.addWhereElement(whereElement);
        }
        if (recruitmentCondition.sex != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "sex_code" + sqlContext.toCondition_string("=", recruitmentCondition.sex.code));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, recruitmentCondition);
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getByLoginId(DtsSession dtsSession, String loginId) throws Exception {
        if (BcStringUtil.isEmpty(loginId)) {
            return null;
        }
        WbsRecruitmentCondition recruitmentCondition = new WbsRecruitmentCondition();
        recruitmentCondition.loginId = loginId;
        List<T> entityList = this.getList(dtsSession, Mode.loginId, recruitmentCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByPersonId(DtsSession dtsSession, long personId) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        WbsRecruitmentCondition recruitmentCondition = new WbsRecruitmentCondition();
        recruitmentCondition.personId = personId;
        List<T> entityList = this.getList(dtsSession, Mode.personId, recruitmentCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByTemporaryId(DtsSession dtsSession, String temporaryId) throws Exception {
        if (BcStringUtil.isEmpty(temporaryId)) {
            return null;
        }
        WbsRecruitmentCondition recruitmentCondition = new WbsRecruitmentCondition();
        recruitmentCondition.temporaryId = temporaryId;
        List<T> entityList = this.getList(dtsSession, Mode.temporaryId, recruitmentCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1AccountDAO(Wbs1AccountDAO wbs1AccountDAO) {
        this();
    }

    public static enum Mode {
        loginId("login_id"),
        personId("person_id"),
        temporaryId("person_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1AccountDAO instance = new Wbs1AccountDAO(null);

        private SingletonHolder() {
        }
    }
}

